package model;

public class LKW extends Fahrzeug
{
	private int eigengewicht;
	private int gesamtgewicht;
	private Anhanger anhanger;
	
	public LKW(String zeile) throws FahrzeugException
	{
		//WN-11111;2019;1300;2900
		//WN-44444;2000;2100;4000;700;1400
		super(zeile);
		try
		{
			String[] teile;
			teile = zeile.split(";");
			setEigengewicht(Integer.parseInt(teile[2].trim()));
			setGesamtgewicht(Integer.parseInt(teile[3].trim()));
			if (teile.length == 6)
			{
				int e;
				int n;
				e = Integer.parseInt(teile[4].trim());
				n = Integer.parseInt(teile[5].trim());
				setAnhanger(new Anhanger(e, n));
			}
		}
		catch (NullPointerException e)
		{
			throw new FahrzeugException("Fehler: kein LKW!");
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FahrzeugException("Fehler: kein LKW!");
		}
		catch (NumberFormatException e)
		{
			throw new FahrzeugException("Fehler: kein gültiges Gewicht!");
		}
	}
	
	public LKW(String kennzeichen, int baujahr, int eigengewicht, int gesamtgewicht) throws FahrzeugException
	{
		super(kennzeichen, baujahr);
		setEigengewicht (eigengewicht);
		setGesamtgewicht (gesamtgewicht);
		setAnhanger(null);
	}

	public LKW(String kennzeichen, int baujahr, int eigengewicht, int gesamtgewicht, Anhanger anhanger) throws FahrzeugException
	{
		super(kennzeichen, baujahr);
		setEigengewicht (eigengewicht);
		setGesamtgewicht (gesamtgewicht);
		setAnhanger(anhanger);
	}

	public Anhanger getAnhanger()
	{
		return anhanger;
	}

	public void setAnhanger(Anhanger anhanger)
	{
		this.anhanger = anhanger;
	}

	public int getEigengewicht()
	{
		return eigengewicht;
	}
	
	public void setEigengewicht(int eigengewicht) throws FahrzeugException
	{
		if (eigengewicht >= 1000)
		{
			this.eigengewicht = eigengewicht;
		}
		else
		{
			throw new FahrzeugException("Fehler: ungültiges Eigengewicht!");
		}
	}
	
	public int getGesamtgewicht()
	{
		return gesamtgewicht;
	}
	
	public void setGesamtgewicht(int gesamtgewicht) throws FahrzeugException
	{
		if (gesamtgewicht >= 1500)
		{
			this.gesamtgewicht = gesamtgewicht;
		}
		else
		{
			throw new FahrzeugException("Fehler: ungültiges Gesamtgewicht!");
		}
	}
	
	@Override
	public String toString()
	{
		if (anhanger != null)
		{
			return super.toString() + " (" + gesamtgewicht + " Total " + eigengewicht + " Eigengewicht )" + anhanger.toString();
		}
		else
		{
			return super.toString() + " (" + gesamtgewicht + " Total " + eigengewicht + " Eigengewicht )";
		}
	}
	
	@Override
	public String toStringCSV()
	{
		if (anhanger != null)
		{
			return super.toStringCSV() + ";" + eigengewicht + ";" + gesamtgewicht + ";" + anhanger.toStringCSV();
		}
		else
		{
			return super.toStringCSV() + ";" + eigengewicht + ";" + gesamtgewicht;
		}
	}

	@Override
	public int berechneNutzlast()
	{
		if (anhanger != null)
		{
			return (gesamtgewicht - eigengewicht) + anhanger.getNutzlast();
		}
		else
		{
			return gesamtgewicht - eigengewicht;
		}
	}

	@Override
	public int berechneEigengewicht()
	{
		if (anhanger != null)
		{
			return eigengewicht + anhanger.berechneEigengewicht();
		}
		else
		{
			return eigengewicht;
		}
	}
}
