package model;

import java.io.Serializable;
import java.util.Comparator;

public abstract class Fahrzeug implements HatLadegewicht, Comparable<Fahrzeug>, Serializable
{
	private String kennzeichen;
	private int baujahr;
	
	public Fahrzeug(String zeile) throws FahrzeugException
	{
		//WN-44444;2000;2100;4000;700;1400
		//BN-43534S
		//BN-43534S;HUGO
		try
		{
			String[] teile;
			teile = zeile.split(";");
			setKennzeichen(teile[0].trim());
			setBaujahr(Integer.parseInt(teile[1].trim()));
		}
		catch (NullPointerException e)
		{
			throw new FahrzeugException("Fehler: kein Fahrzeug!");
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FahrzeugException("Fehler: kein Fahrzeug!");
		}
		catch (NumberFormatException e)
		{
			throw new FahrzeugException("Fehler: kein gültiges Baujahr!");
		}
	}
	
	public Fahrzeug(String kennzeichen, int baujahr) throws FahrzeugException
	{
		super();
		setKennzeichen(kennzeichen);
		setBaujahr(baujahr);
	}

	public String getKennzeichen()
	{
		return kennzeichen;
	}
	
	public void setKennzeichen(String kennzeichen) throws FahrzeugException
	{
		if ((kennzeichen != null) && (kennzeichen.length() >= 6))
		{
			this.kennzeichen = kennzeichen;
		}
		else
		{
			throw new FahrzeugException("Fehler: ungültiges Kennzeichen!");
		}
	}
	
	public int getBaujahr()
	{
		return baujahr;
	}
	
	public void setBaujahr(int baujahr) throws FahrzeugException
	{
		if ((baujahr >= 1980) && (baujahr <= 2020))
		{
			this.baujahr = baujahr;
		}
		else
		{
			throw new FahrzeugException("Fehler: ungültiges Baujahr!");
		}
	}
	
	@Override
	public String toString()
	{
		return kennzeichen + " (" + berechneNutzlast() + ") " + baujahr + " Baujahr";
	}
	
	public String toStringCSV()
	{
		return kennzeichen + ";" + baujahr;
	}
	
	@Override
	public int compareTo(Fahrzeug other)
	{
		if (this.berechneNutzlast() == other.berechneNutzlast())
		{
			return other.baujahr - this.baujahr;
		}
		else
		{
			return this.berechneNutzlast() - other.berechneNutzlast();
		}
	}
	
	public static class KennzeichenComparator implements Comparator<Fahrzeug>
	{
		@Override
		public int compare(Fahrzeug f0, Fahrzeug f1)
		{
			return f0.kennzeichen.compareTo(f1.kennzeichen);
		}
	}
}















