package model;

import java.io.Serializable;

public class Anhanger implements HatLadegewicht, Serializable
{
	private int      eigengewicht;
	private int      nutzlast;
	
	public Anhanger(int eigengewicht, int nutzlast)
	{
		setEigengewicht (eigengewicht);
		setNutzlast (nutzlast);
	}

	public int getEigengewicht()
	{
		return eigengewicht;
	}
	
	public void setEigengewicht(int eigengewicht)
	{
		this.eigengewicht = eigengewicht;
	}
	
	public int getNutzlast()
	{
		return nutzlast;
	}
	
	public void setNutzlast(int nutzlast)
	{
		this.nutzlast = nutzlast;
	}

	@Override
	public String toString()
	{
		return "Anhanger " + eigengewicht + " Eigengewicht + " + nutzlast + " Nutzlast";
	}

	public String toStringCSV()
	{
		return eigengewicht + ";" + nutzlast;
	}
	
	@Override
	public int berechneNutzlast()
	{
		return nutzlast;
	}

	@Override
	public int berechneEigengewicht()
	{
		return eigengewicht;
	}
}
