package test;

import model.DriveThrough;
import model.FastFoodRestaurant;
import model.RestaurantException;
import model.RestaurantKette;

public class TestRestaurantKette
{
	public static void main(String[] args)
	{
		testExportRestaurants();
	}

	public static void testExportRestaurants()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f1);
			rk.hinzufugen(f2);
			rk.hinzufugen(f3);
			rk.hinzufugen(f4);
			rk.hinzufugen(f5);
			System.out.println(rk);                        
			System.out.println("======================");
			rk.exportRestaurants("resaurants2.txt");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}			
	}

	
	public static void testImportRestaurants()
	{
		RestaurantKette rk;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			rk.importRestaurants("restaurants.txt");
			System.out.println(rk);                        
			System.out.println("======================");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}			
	}
	
	public static void testLoadRestaurants()
	{
		RestaurantKette rk;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			rk.loadRestaurants("resaurants.ser");
			System.out.println(rk);                        
			System.out.println("======================");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}			
	}

	
	public static void testSaveRestaurants()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f1);
			rk.hinzufugen(f2);
			rk.hinzufugen(f3);
			rk.hinzufugen(f4);
			rk.hinzufugen(f5);
			System.out.println(rk);                        
			System.out.println("======================");
			rk.saveRestaurants("resaurants.ser");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}			
	}
	
	public static void testSortOrtName()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f1);
			rk.hinzufugen(f2);
			rk.hinzufugen(f3);
			rk.hinzufugen(f4);
			rk.hinzufugen(f5);
			System.out.println(rk);                        
			System.out.println("======================");
			rk.sortOrtName();
			System.out.println(rk);                        
			System.out.println("======================");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}		
	}
	
	public static void testSortUmsatzJahr()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f1);
			rk.hinzufugen(f2);
			rk.hinzufugen(f3);
			rk.hinzufugen(f4);
			rk.hinzufugen(f5);
			System.out.println(rk);                        
			System.out.println("======================");
			rk.sortUmsatzJahr();
			System.out.println(rk);                        
			System.out.println("======================");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}		
	}
	
	public static void testLoscheRestaurants()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f1);
			rk.hinzufugen(f2);
			rk.hinzufugen(f3);
			rk.hinzufugen(f4);
			rk.hinzufugen(f5);
			System.out.println(rk);                        //6
			System.out.println("======================");
			rk.loscheRestaurants("Mödling");
			System.out.println(rk);                        //6
			System.out.println("======================");
			rk.loscheRestaurants("Wien");
			System.out.println(rk);                        //4
			System.out.println("======================");
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}		
	}	
	
	
	public static void testGetSummeDeckungsbeitrage()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			System.out.println(rk.getSummeDeckungsbeitrage());                //0
			rk.hinzufugen(f0);
			System.out.println(f0 + "   " + f0.berechneDeckungsbeitragJahr());
			rk.hinzufugen(f1);
			System.out.println(f1 + "   " + f1.berechneDeckungsbeitragJahr());
			rk.hinzufugen(f2);
			System.out.println(f2 + "   " + f2.berechneDeckungsbeitragJahr());
			rk.hinzufugen(f3);
			System.out.println(f3 + "   " + f3.berechneDeckungsbeitragJahr());
			rk.hinzufugen(f4);
			System.out.println(f4 + "   " + f4.berechneDeckungsbeitragJahr());
			rk.hinzufugen(f5);
			System.out.println(f5 + "   " + f5.berechneDeckungsbeitragJahr());
			System.out.println("======================");
			System.out.println(rk.getSummeDeckungsbeitrage());
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}		
	}	
	
	public static void testMaxUmsatzJahr()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			System.out.println(rk.getMaxUmsatzJahr());                //null
			rk.hinzufugen(f0);
			System.out.println(f0 + "   " + f0.berechneUmsatzJahr());
			rk.hinzufugen(f1);
			System.out.println(f1 + "   " + f1.berechneUmsatzJahr());
			rk.hinzufugen(f2);
			System.out.println(f2 + "   " + f2.berechneUmsatzJahr());
			rk.hinzufugen(f3);
			System.out.println(f3 + "   " + f3.berechneUmsatzJahr());
			rk.hinzufugen(f4);
			System.out.println(f4 + "   " + f4.berechneUmsatzJahr());
			rk.hinzufugen(f5);
			System.out.println(f5 + "   " + f5.berechneUmsatzJahr());
			System.out.println("======================");
			System.out.println(rk.getMaxUmsatzJahr());
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}		
	}

	public static void testHinzufugen()
	{
		RestaurantKette rk;
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			rk.hinzufugen(null);
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());          //Fehler: ungült. Res.
		}
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f0);
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());         //Fehler: ungült. Res.
		}
		try
		{
			rk = new RestaurantKette("Super Eat 8");
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			rk.hinzufugen(f0);
			rk.hinzufugen(f1);
			rk.hinzufugen(f2);
			rk.hinzufugen(f3);
			rk.hinzufugen(f4);
			rk.hinzufugen(f5);
			System.out.println(rk);
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}
	
	}
}
