package test;

import model.DriveThrough;
import model.FastFoodRestaurant;
import model.RestaurantException;

public class TestRestaurant
{

	public static void main(String[] args)
	{
		testKosten();
	}

	public static void testKosten()
	{
		FastFoodRestaurant f0, f1, f2, f3, f4, f5;
		
		try
		{
			f0 = new FastFoodRestaurant("Mc Donalds",   "Wien",             8, 1600,  18000);
			f1 = new FastFoodRestaurant("Würstel & Co", "Wiener Neustadt", 10,  800, 260000, new DriveThrough(200, 4.9));
			f2 = new FastFoodRestaurant("Mc Donalds",   "Baden",            4, 1000, 420000);
			f3 = new FastFoodRestaurant("Mc Schnitzl",  "Baden",            6,  900,  14000);
			f4 = new FastFoodRestaurant("Mc Schnitzl",  "Wien",             9,  800, 300000, new DriveThrough(400, 6.9));
			f5 = new FastFoodRestaurant("WürstelBox",   "Wiener Neustadt", 10,  700,  19000);
			System.out.println(f0);
			System.out.println(f0.berechneKostenJahr() + " " + f0.berechneUmsatzJahr() + " " + f0.berechneDeckungsbeitragJahr());
			System.out.println(f1);
			System.out.println(f1.berechneKostenJahr() + " " + f1.berechneUmsatzJahr() + " " + f1.berechneDeckungsbeitragJahr());
			System.out.println(f2);
			System.out.println(f2.berechneKostenJahr() + " " + f2.berechneUmsatzJahr() + " " + f2.berechneDeckungsbeitragJahr());
			System.out.println(f3);
			System.out.println(f3.berechneKostenJahr() + " " + f3.berechneUmsatzJahr() + " " + f3.berechneDeckungsbeitragJahr());
			System.out.println(f4);
			System.out.println(f4.berechneKostenJahr() + " " + f4.berechneUmsatzJahr() + " " + f4.berechneDeckungsbeitragJahr());
			System.out.println(f5);
			System.out.println(f5.berechneKostenJahr() + " " + f5.berechneUmsatzJahr() + " " + f5.berechneDeckungsbeitragJahr());
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}		
	}
	
	public static void testRestaurant()
	{
		FastFoodRestaurant f0, f1, f2, f3, f4;
		
		try
		{
			f0 = new FastFoodRestaurant("Mc Donalds", "Wien", 8, 1600, 18000);
			System.out.println(f0);                                           //McDonalds Wien
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			f1 = new FastFoodRestaurant("Mc Donalds", null, 8, 1600, 18000);
			System.out.println(f1);
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());                             //Fehler: ungültiger Ort!
		}
		try
		{
			f2 = new FastFoodRestaurant("Mc Donalds", "W", 8, 1600, 18000);
			System.out.println(f2);                                        
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());                            //Fehler: ungültiger Ort!
		}
		try
		{
			f3 = new FastFoodRestaurant("Mc Donalds", "Wien", 3, 1600, 18000);
			System.out.println(f3);
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());                            //Fehler: mind. 4 Mitarb.!
		}
		try
		{
			f4 = new FastFoodRestaurant("Mc Big Menu", "Baden", 8, 3000, 59000, new DriveThrough(600, 5.9));
			System.out.println(f4);                                       //Mc Big Baden ... 600 5.9
		}
		catch (RestaurantException e)
		{
			System.out.println(e.getMessage());                            
		}	}
}
