package model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RestaurantKette
{
	private String firmenName;
	private ArrayList<Restaurant> restaurants;
	
	public RestaurantKette(String firmenName)
	{
		setFirmenName(firmenName);
		restaurants = new ArrayList<Restaurant>(10);
	}
	public String getFirmenName()
	{
		return firmenName;
	}
	public void setFirmenName(String firmenName)
	{
		this.firmenName = firmenName;
	}
	
	public void hinzufugen(Restaurant welches) throws RestaurantException
	{
		if ((welches != null) && (restaurants.contains(welches)==false))
		{
			restaurants.add(welches);
		}
		else
		{
			throw new RestaurantException("Fehler: ungültiges Restaurant!");
		}
	}
	
	public double getSummeDeckungsbeitrage()
	{
		double summe;
		
		summe = 0;
		for (Restaurant r: restaurants)
		{
			summe += r.berechneDeckungsbeitragJahr();
		}
		return summe;
	}
	
	public Restaurant getMaxUmsatzJahr()
	{
		double maxUmsatz;
		Restaurant maxRestaurant;
		
		maxUmsatz = -9999999;
		maxRestaurant = null;
		for (Restaurant r: restaurants)
		{
			if (maxUmsatz < r.berechneUmsatzJahr())
			{
				maxUmsatz = r.berechneUmsatzJahr();
				maxRestaurant = r;
			}
		}
		return maxRestaurant;
	}
	
	public void loscheRestaurants(String stadt)
	{
		Iterator<Restaurant> iterator;
		Restaurant restaurant;
		
		 iterator = restaurants.iterator();
		 while (iterator.hasNext())
		 {
			 restaurant = iterator.next();
			 if (restaurant.getRestaurantOrt().toUpperCase().equals(stadt.toUpperCase()))
			 {
				 iterator.remove();
			 }
		 }
	}
	
	public void sortUmsatzJahr()
	{
		Collections.sort(restaurants);
	}

	public void sortOrtName()
	{
		Collections.sort(restaurants, new RestaurantKette.OrtNameComparator());
	}

	public void exportRestaurants(String filename) throws RestaurantException
	{
		try
		{
			FileWriter fileWriter = new FileWriter(filename);
			BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
			bufferedWriter.write(toStringCSV());
			bufferedWriter.close();
			fileWriter.close();
		}
		catch (FileNotFoundException e)
		{
			throw new RestaurantException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new RestaurantException("Fehler: Datei konnte nicht geschrieben werden!");
		}		
	}
	
	public void importRestaurants(String filename) throws RestaurantException
	{
		try
		{
			String zeile;
			FileReader fileReader = new FileReader(filename);
			BufferedReader bufferedReader = new BufferedReader(fileReader);
			zeile = bufferedReader.readLine();
			while (zeile != null)
			{
				FastFoodRestaurant f = new FastFoodRestaurant(zeile);
				hinzufugen(f);
				zeile = bufferedReader.readLine();				
			}
			bufferedReader.close();
			fileReader.close();
		}
		catch (FileNotFoundException e)
		{
			throw new RestaurantException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new RestaurantException("Fehler: Datei konnte nicht gelesen werden!");
		}		
	}
	
	public void loadRestaurants(String filename) throws RestaurantException
	{
		try
		{
			FileInputStream fileInputStream = new FileInputStream(filename);
			ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
			restaurants = (ArrayList<Restaurant>) objectInputStream.readObject();
			objectInputStream.close();
			fileInputStream.close();
		}
		catch (FileNotFoundException e)
		{
			throw new RestaurantException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new RestaurantException("Fehler: Datei konnte nicht gelesen werden!");
		}
		catch (ClassNotFoundException e)
		{
			throw new RestaurantException("Fehler: keine Restaurant Datei!");
		}		
	}

	
	public void saveRestaurants(String filename) throws RestaurantException
	{
		try
		{
			FileOutputStream fileOutputStream = new FileOutputStream(filename);
			ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
			objectOutputStream.writeObject(restaurants);
			objectOutputStream.close();
			fileOutputStream.close();
		}
		catch (FileNotFoundException e)
		{
			throw new RestaurantException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			System.out.println(e);
			throw new RestaurantException("Fehler: Datei konnte nicht geschrieben werden!");
		}		
	}
	
	public String toStringCSV()
	{
		String erg;
		
		erg = "";
		for (Restaurant r: restaurants)
		{
			erg += r.toStringCSV() + "\n";
		}
		return erg;
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = firmenName + "\n\n";
		for (Restaurant r: restaurants)
		{
			erg += r.toString() + "\n";
		}
		return erg;
	}
	
	public static class OrtNameComparator implements Comparator<Restaurant>
	{
		public int compare(Restaurant restaurant0, Restaurant restaurant1)
		{
			if (restaurant0.getRestaurantOrt().compareTo(restaurant1.getRestaurantOrt()) == 0)
			{
				return (restaurant0.getRestaurantName().compareTo(restaurant1.getRestaurantName()));
			}
			else
			{
				return restaurant0.getRestaurantOrt().compareTo(restaurant1.getRestaurantOrt());
			}
		}
	}
}




















