package model;

import java.io.Serializable;

public abstract class Restaurant implements HatKostenUmsatz, Comparable<Restaurant>, Serializable
{
	private String restaurantName;
	private String restaurantOrt;
	private int anzahlMitarbeiter;
	private double mieteMonat;

	public Restaurant(String zeile) throws RestaurantException
	{
		String[] teile;
		
		try
		{
			teile = zeile.split(";");
			setRestaurantName(teile[0].trim());
			setRestaurantOrt(teile[1].trim());
			setAnzahlMitarbeiter(Integer.parseInt(teile[2].trim()));
			setMieteMonat(Double.parseDouble(teile[3].trim()));
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new RestaurantException("Fehler: zu wenig Felder!");
		}
		catch (NumberFormatException e)
		{
			throw new RestaurantException("Fehler: Umsatz oder Mitarbeiteranzahl keine Zahl!");
		}
	}
	
	public Restaurant(String restaurantName, String restaurantOrt, int anzahlMitarbeiter, double mieteMonat) throws RestaurantException
	{
		setRestaurantName(restaurantName);
		setRestaurantOrt(restaurantOrt);
		setAnzahlMitarbeiter(anzahlMitarbeiter);
		setMieteMonat(mieteMonat);
	}

	public String getRestaurantName()
	{
		return restaurantName;
	}
	
	public void setRestaurantName(String restaurantName)
	{
		this.restaurantName = restaurantName;
	}
	
	public String getRestaurantOrt()
	{
		return restaurantOrt;
	}
	
	public void setRestaurantOrt(String restaurantOrt) throws RestaurantException
	{
		if ((restaurantOrt != null) && (restaurantOrt.length() >= 2))
		{
			this.restaurantOrt = restaurantOrt;
		}
		else
		{
			throw new RestaurantException("Fehler: ungültiger Ort!");
		}
	}
	
	public int getAnzahlMitarbeiter()
	{
		return anzahlMitarbeiter;
	}
	
	public void setAnzahlMitarbeiter(int anzahlMitarbeiter) throws RestaurantException
	{
		if (anzahlMitarbeiter >= 4)
		{
			this.anzahlMitarbeiter = anzahlMitarbeiter;
		}
		else
		{
			throw new RestaurantException("Fehler: mind. 4 Mitarbeiter!");
		}
	}
	
	public double getMieteMonat()
	{
		return mieteMonat;
	}
	
	public void setMieteMonat(double mieteMonat)
	{
		this.mieteMonat = mieteMonat;
	}
	
	@Override
	public double berechneDeckungsbeitragJahr()
	{
		return berechneUmsatzJahr() - berechneKostenJahr();
	}

	public String toStringCSV()
	{
		return restaurantName + ";" + restaurantOrt + ";" + anzahlMitarbeiter + ";" + mieteMonat;
	}
	
	@Override
	public String toString()
	{
		return restaurantName + " (" + restaurantOrt + ") " + anzahlMitarbeiter + " Ang. Miete:" + mieteMonat;
	}
	
	@Override
	public int compareTo(Restaurant other)
	{
		return (int) (this.berechneUmsatzJahr() - other.berechneUmsatzJahr());
	}

}
