package model;

public class FastFoodRestaurant extends Restaurant
{
	private double umsatzMonat;
	private DriveThrough driveThrough;

	public FastFoodRestaurant(String zeile) throws RestaurantException
	{
		super(zeile);
		//Mc Donalds;Wien;8;1600;18000
		//Würstel & Co;Wiener Neustadt;10;800;260000;200;4.9
		String[] teile;
		
		try
		{
			teile = zeile.split(";");
			setUmsatzMonat(Double.parseDouble(teile[4].trim()));
			if (teile.length > 5)
			{
				DriveThrough dt;
				int anz = Integer.parseInt(teile[5].trim());
				double preis = Double.parseDouble(teile[6].trim());
				dt = new DriveThrough(anz, preis);
				setDriveThrough(dt);
			}
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new RestaurantException("Fehler: zu wenig Felder!");
		}
		catch (NumberFormatException e)
		{
			throw new RestaurantException("Fehler: Umsatz oder Mitarbeiteranzahl keine Zahl!");
		}
	}
	
	public FastFoodRestaurant(String restaurantName, String restaurantOrt, int anzahlMitarbeiter, double mieteMonat,
			double umsatzMonat, DriveThrough driveThrough) throws RestaurantException
	{
		super(restaurantName, restaurantOrt, anzahlMitarbeiter, mieteMonat);
		setUmsatzMonat(umsatzMonat);
		setDriveThrough(driveThrough);
	}

	public FastFoodRestaurant(String restaurantName, String restaurantOrt, int anzahlMitarbeiter, double mieteMonat,
			double umsatzMonat) throws RestaurantException
	{
		super(restaurantName, restaurantOrt, anzahlMitarbeiter, mieteMonat);
		setUmsatzMonat(umsatzMonat);
		setDriveThrough(null);
	}

	public DriveThrough getDriveThrough()
	{
		return driveThrough;
	}

	public void setDriveThrough(DriveThrough driveThrough)
	{
		this.driveThrough = driveThrough;
	}

	public double getUmsatzMonat()
	{
		return umsatzMonat;
	}

	public void setUmsatzMonat(double umsatzMonat)
	{
		this.umsatzMonat = umsatzMonat;
	}

	@Override
	public String toStringCSV()
	{
		if (driveThrough != null)
		{
			return super.toStringCSV() + ";" + umsatzMonat + ";" + driveThrough.toStringCSV();
		}
		else
		{
			return super.toStringCSV() + ";" + umsatzMonat;
		}
	}
	
	@Override
	public String toString()
	{
		if (driveThrough != null)
		{
			return super.toString() + " Umsatz:" + umsatzMonat + driveThrough.toString();
		}
		else
		{
			return super.toString() + " Umsatz:" + umsatzMonat;
		}
	}

	@Override
	public double berechneUmsatzJahr()
	{
		if (driveThrough != null)
		{
			return (umsatzMonat*12) + (driveThrough.getAnzahlMenuJahr()*driveThrough.getPreisMenu());
		}
		else
		{
			return (umsatzMonat*12);
		}
	}

	@Override
	public double berechneKostenJahr()
	{
	    return (getAnzahlMitarbeiter()*1500*2*14) + (getMieteMonat()*12);
	}
}
