package test;

import model.Grundstuck;
import model.Immobilie;
import model.ImmobilieException;
import model.Wohnung;
import model.WohnungBalkon;

public class TestImmobilie
{

	public static void main(String[] args)
	{
		testGetPreis();
	}
	
	public static void testGetPreis()
	{
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;
		
		try
		{
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			System.out.println(g0);
			System.out.println(g1);
			System.out.println(g2);
			System.out.println(g3);
			System.out.println(g4);
			System.out.println(w0);
			System.out.println(w1);
			System.out.println(w2);
			System.out.println(w3);
			System.out.println(w4);
			System.out.println(b0);
			System.out.println(b1);
			System.out.println(b2);
			System.out.println(b3);
			System.out.println(b4);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testWohnungBalkon()
	{
		WohnungBalkon b0, b1;
		
		try
		{
			b0 = new WohnungBalkon("Wien", 't', 60, 2, true, 20); 
			System.out.println(b0);                     //Wien TOP 60m² 2 Zimmer - HELL - 20m² Balkon
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			b1 = new WohnungBalkon("Wien", 'n', 90, 4, false, 9); 
			System.out.println(b1);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());       //Fehler: mind 10m² Balkon
		}
	}
	
	public static void testGrundstuck()
	{
		Grundstuck g0, g1, g2, g3;
		
		try
		{
			g0 = new Grundstuck("Baden", 't', 800, true);
			System.out.println(g0);                      //Baden TOP 800m² BEBAUBAR
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			g1 = new Grundstuck("Mödling", 'n', 4000, false);
			System.out.println(g1);                     //Mödling NORMAL 4000m² GRÜNFLÄCHE
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			g2 = new Grundstuck("Mödling", 'n', 10, false);
			System.out.println(g2);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());        //Fehler: mind. 300m²
		}
	}
	
	public static void testWohnung()
	{
		Wohnung w0, w1, w2, w3, w4;
		
		try
		{
			w0 = new Wohnung("Wien", 't', 60, 2, true); 
			System.out.println(w0);                     //Wien TOP 60m² 2 Zimmer - HELL
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			w3 = new Wohnung("Wien", 'n', 90, 4, false); 
			System.out.println(w3);                     //Wien NORMAL 90m² 4 Zimmer - DUNKEL
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			w1 = new Wohnung("Wien", 't', 0, 2, true);
			System.out.println(w1);                   //Fehler: mind. 20m²
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}		try
		{
			w2 = new Wohnung("Wien", 't', 60, 0, true);
			System.out.println(w2);                    //Fehler: mind. 1 Zimmer
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			w4 = new Wohnung("Wien", 'X', 60, 4, true);
			System.out.println(w4);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage()); //Fehler: ungültige Lage
		}
	}
}
