package test;

import model.Grundstuck;
import model.ImmobilieException;
import model.Wohnung;
import model.WohnungBalkon;
import model.Handler;

public class TestHandler
{
	public static void main(String[] args)
	{
		testImportImmobilie2();
	}

	public static void testImportImmobilie2()
	{
		Handler h;

		try
		{
			h = new Handler("Super Immo Center!");
			h.importImmobilie("immobilien2.txt");
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testExportImmobilie()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			h.exportImmobilie("immobilien2.txt");
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testImportImmobilie()
	{
		Handler h;

		try
		{
			h = new Handler("Super Immo Center!");
			h.importImmobilie("immobilien.txt");
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testLoadImmobilie()
	{
		Handler h;

		try
		{
			h = new Handler("Super Immo Center!");
			h.loadImmobilie("immobilien.ser");
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testSaveImmobilie()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			h.saveImmobilie("immobilien.ser");
			h.saveImmobilie("/gibtsnicht/immobilien.ser");
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}

	public static void testSortOrt()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			h.sortOrt();
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testSortPreis()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			h.sortPreis();
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testLoscheGrundstuck()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			h.loschenGrundstuck(1000000000);
			System.out.println(h);
			System.out.println("=========================================");
			h.loschenGrundstuck(300000);
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testLoscheImmobilie()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			h.loschenImmobilie("Wien");
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testGunstigeBaugrund()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		h = new Handler("Super Immo Center!");
		System.out.println(h.getGunstigeBaugrund());
		
		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			System.out.println(h.getGunstigeBaugrund());			
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testGunstigeWohnung()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;

		h = new Handler("Super Immo Center!");
		System.out.println(h.getGunstigeWohnung());
		
		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			System.out.println(h.getGunstigeWohnung());			
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testGunstigeImmobilie()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;
		
		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
			System.out.println("=========================================");
			System.out.println(h.getGunstigeImmobilie());			
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testAufnehmen()
	{
		Handler h;
		Grundstuck g0, g1, g2, g3, g4;
		Wohnung w0, w1, w2, w3, w4;
		WohnungBalkon b0, b1, b2, b3, b4;
		
		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			g1 = new Grundstuck("Baden",           'n',  900, false);
			g2 = new Grundstuck("Wiener Neustadt", 'n',  700, true);
			g3 = new Grundstuck("Baden",           's', 2000, false);
			g4 = new Grundstuck("Baden",           'n',  900, true);
			w0 = new Wohnung("Wien",    'n',  80, 3, true);
			w1 = new Wohnung("Wien",    't',  60, 2, false);
			w2 = new Wohnung("Baden",   't',  90, 1, true);
			w3 = new Wohnung("Mödling", 't', 100, 2, false);
			w4 = new Wohnung("Wien",    's', 120, 8, true);
			b0 = new WohnungBalkon("Wien",    'n',  80, 3, true,  30);
			b1 = new WohnungBalkon("Baden",   'n',  90, 3, false, 10);
			b2 = new WohnungBalkon("Mödling", 't',  60, 3, true,  30);
			b3 = new WohnungBalkon("Baden",   't',  30, 1, true,  10);
			b4 = new WohnungBalkon("Wien",    'n',  30, 1, true,  30);
			h.aufnehmen(g0);
			h.aufnehmen(b1);
			h.aufnehmen(g2);
			h.aufnehmen(w0);
			h.aufnehmen(g1);
			h.aufnehmen(w1);
			h.aufnehmen(w3);
			h.aufnehmen(g3);
			h.aufnehmen(b3);
			h.aufnehmen(b2);
			h.aufnehmen(g4);
			h.aufnehmen(b0);
			h.aufnehmen(w2);
			h.aufnehmen(w4);
			h.aufnehmen(b4);
			System.out.println(h);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			h = new Handler("Super Immo Center!");
			g0 = new Grundstuck("Wien",            't', 1000, true);
			h.aufnehmen(g0);
			h.aufnehmen(g0);
		}
		catch (ImmobilieException e)
		{
			System.out.println(e.getMessage());
		}
	}
}
