package model;

public class WohnungBalkon extends Wohnung
{
	private int mmBalkon;

	public WohnungBalkon(String zeile) throws ImmobilieException
	{
		super(zeile);
		
		try
		{
			String[] teile;
			teile = zeile.split(";");
			setMmBalkon(Integer.parseInt(teile[6].trim()));
		}
		catch (NumberFormatException | IndexOutOfBoundsException e)
		{
			throw new ImmobilieException("Fehler: ungültiges Format!");
		}	
	}
	
	public WohnungBalkon(String ort, char lage, int mm, int zimmer, boolean hell, int mmBalkon)
			throws ImmobilieException
	{
		super(ort, lage, mm, zimmer, hell);
		setMmBalkon(mmBalkon);
	}

	public int getMmBalkon()
	{
		return mmBalkon;
	}

	public void setMmBalkon(int mmBalkon) throws ImmobilieException
	{
		if (mmBalkon >= 10)
		{
			this.mmBalkon = mmBalkon;
		}
		else
		{
			throw new ImmobilieException("Fehler: Balkon mind. 10m²");
		}
	}
	
	@Override
	public String toStringCSV()
	{
		if (getHell())
			return "Balkon;" + getOrt() + ";" + getLage() + ";" + getMm() + ";" + getZimmer() + ";H;" + mmBalkon;
		else
			return "Balkon;" + getOrt() + ";" + getLage() + ";" + getMm() + ";" + getZimmer() + ";D;" + mmBalkon;
	}
	
	@Override
	public String toString()
	{
		return super.toString() + " - " + mmBalkon + "m² Balkon";
	}
	
	@Override
	public double getPreis()
	{
		return super.getPreis() + 500*mmBalkon;
	}
}






