package model;

public class Wohnung extends Immobilie
{
	private int zimmer;
	private boolean hell;
	
	public Wohnung(String zeile) throws ImmobilieException
	{
		super(zeile);
		
		try
		{
			String[] teile;
			teile = zeile.split(";");
			setZimmer(Integer.parseInt(teile[4].trim()));
			if (teile[5].trim().charAt(0)=='H')
				setHell(true);
			else
				setHell(false);
		}
		catch (NumberFormatException | IndexOutOfBoundsException e)
		{
			throw new ImmobilieException("Fehler: ungültiges Format!");
		}	
	}
	
	public Wohnung(String ort, char lage, int mm, int zimmer, boolean hell) throws ImmobilieException
	{
		super(ort, lage, mm);
		setZimmer(zimmer);
		setHell(hell);
	}
	
	public void setMm(int mm) throws ImmobilieException
	{
		if (mm >= 20)
		{
			this.mm = mm;
		}
		else
		{
			throw new ImmobilieException("Fehler: mind. 20 m²!");
		}
	}
	
	public int getZimmer()
	{
		return zimmer;
	}
	
	public void setZimmer(int zimmer) throws ImmobilieException
	{
		if (zimmer >= 1)
		{
			this.zimmer = zimmer;
		}
		else
		{
			throw new ImmobilieException("Fehler: mind. 1 Zimmer!");
		}
	}
	
	public boolean getHell()
	{
		return hell;
	}
	
	public void setHell(boolean hell)
	{
		this.hell = hell;
	}

	@Override
	public String toStringCSV()
	{
		if (hell)
			return "Wohnung;" + super.toStringCSV() + ";" + zimmer + ";H";
		else
			return "Wohnung;" + super.toStringCSV() + ";" + zimmer + ";D";			
	}
	
	@Override
	public String toString()
	{
		if (hell)
		{
			return "Wohnung: " + super.toString() + " " + mm + "m² " + zimmer + " Zimmer " + " - HELL";
		}
		else
		{
			return "Wohnung: " + super.toString() + " " + mm + "m² " + zimmer + " Zimmer " + " - DUNKEL";
		}
	}

	@Override
	public double getPreis()
	{
		if (hell == true)
		{
			if (zimmer > 5)
			{
				return (mm * 2000) + 30000 - 10000;
			}
			else
			{
				return (mm * 2000) + 30000;
			}
		}
		else
		{
			if (zimmer > 5)
			{
				return (mm * 2000) - 10000;
			}
			else
			{
				return (mm * 2000);
			}
		}
	}
}
