package model;

import java.io.Serializable;
import java.util.Comparator;

public abstract class Immobilie implements HatKaufpreis, Comparable<Immobilie>, Serializable
{
	private String ort;
	private char   lage;
	protected int  mm;
	
	public Immobilie(String zeile) throws ImmobilieException
	{
		try
		{
			String[] teile;
			teile = zeile.split(";");
			setOrt(teile[1].trim());
			setLage(teile[2].trim().charAt(0));
			setMm(Integer.parseInt(teile[3].trim()));
		}
		catch (NumberFormatException | IndexOutOfBoundsException e)
		{
			throw new ImmobilieException("Fehler: ungültiges Format!");
		}		
	}
	
	public Immobilie(String ort, char lage, int mm) throws ImmobilieException
	{
		setOrt(ort);
		setLage(lage);
		setMm(mm);
	}
	
	public int getMm()
	{
		return mm;
	}
	
	public abstract void setMm(int mm) throws ImmobilieException;
	
	public String getOrt()
	{
		return ort;
	}
	
	public void setOrt(String ort)
	{
		this.ort = ort;
	}
	
	public char getLage()
	{
		return lage;
	}
	
	public void setLage(char lage) throws ImmobilieException
	{
		if (lage == 't' || lage == 'n' || lage == 's')
		{
			this.lage = lage;
		}
		else
		{
			throw new ImmobilieException("Fehler: ungültige Lage!");
		}
	}

	public String toStringCSV()
	{
		return ort + ";" + lage + ";" + mm;
	}
	
	@Override
	public String toString()
	{
		if (lage == 't')
			return ort + " TOP Lage " + mm +  "m²: " + getPreis() + "€";
		if (lage == 'n')
			return ort + " NORMALE Lage " + mm +  "m²: " + getPreis() + "€";
		if (lage == 's')
			return ort + " SCHLECHTE Lage " + mm +  "m²: " + getPreis() + "€";
		return null;
	}
	
	@Override
	public int compareTo(Immobilie andere)
	{
		return (int) (this.getPreis() - andere.getPreis()); 
	}
	
	public static class OrtComparator implements Comparator<Immobilie>
	{
		@Override
		public int compare(Immobilie i1, Immobilie i2)
		{
			if (i1.ort.equals(i2.ort))
			{
				return i1.mm - i2.mm;
			}
			else
			{
				return i1.ort.compareTo(i2.ort);
			}
		}
	}
}









