package model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Handler
{
	private String firma;
	private ArrayList<Immobilie> immobilien;
	
	public Handler(String firma)
	{
		setFirma(firma);
		immobilien = new ArrayList<Immobilie>(20);
	}
	
	public String getFirma()
	{
		return firma;
	}
	
	public void setFirma(String firma)
	{
		this.firma = firma;
	}
	
	public void aufnehmen(Immobilie neu) throws ImmobilieException
	{
		if (immobilien.contains(neu) == false)
		{
			immobilien.add(neu);
		}
		else
		{
			throw new ImmobilieException("Fehler: schon vorhanden!");
		}
	}

	public Immobilie getGunstigeImmobilie()
	{
		double minPreis;
		Immobilie minImmobilie;
		
		minImmobilie = null;
		minPreis = 999999999;
		for (Immobilie immo: immobilien)
		{
			if (immo.getPreis() < minPreis)
			{
				minPreis = immo.getPreis();
				minImmobilie = immo;
			}
		}
		return minImmobilie;
	}
	
	public Wohnung getGunstigeWohnung()
	{
		double minPreis;
		Wohnung minWohnung;
		
		minWohnung = null;
		minPreis = 999999999;
		for (Immobilie immo: immobilien)
		{
			if (immo instanceof Wohnung)
			{
				if (immo.getPreis() < minPreis)
				{
					minPreis = immo.getPreis();
					minWohnung = (Wohnung)immo;
				}
			}
		}
		return minWohnung;
	}
	
	public Grundstuck getGunstigeBaugrund()
	{
		double minPreis;
		Grundstuck minGrundstuck;
		
		minGrundstuck = null;
		minPreis = 999999999;
		for (Immobilie immo: immobilien)
		{
			if (immo instanceof Grundstuck)
			{
				if ((immo.getPreis() < minPreis) && (((Grundstuck) immo).getBebaubar()))
				{
					minPreis = immo.getPreis();
					minGrundstuck = (Grundstuck)immo;
				}
			}
		}
		return minGrundstuck;
	}
	
	public void loschenGrundstuck(double preis)
	{
		Iterator<Immobilie> iterator;
		Immobilie immobilie;
		Grundstuck grundstuck;
		
		iterator = immobilien.iterator();
		while (iterator.hasNext())
		{
			immobilie = iterator.next();
			if (immobilie instanceof Grundstuck)
			{
				grundstuck = (Grundstuck)immobilie;
				if (grundstuck.getPreis() > preis)
				{
					iterator.remove();
				}
			}
		}
	}
	
	public void loschenImmobilie(String ort)
	{
		Iterator<Immobilie> iterator;
		Immobilie immo;
		
		iterator = immobilien.iterator();
		while (iterator.hasNext())
		{
			immo = iterator.next();
			if (immo.getOrt().equals(ort)==true)
			{
				iterator.remove();
			}
		}
	}
	
	public void sortOrt()
	{
		Collections.sort(immobilien, new Immobilie.OrtComparator());
	}
	
	public void sortPreis()
	{
		Collections.sort(immobilien);
	}
	
	public void exportImmobilie(String filename) throws ImmobilieException
	{
		try
		{
			FileWriter fileWriter = new FileWriter(filename);
			BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
			bufferedWriter.write(toStringCSV());
			bufferedWriter.close();
			fileWriter.close();
		}
		catch (FileNotFoundException e)
		{
			throw new ImmobilieException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new ImmobilieException("Fehler: Datei konnte nicht gelesen werden!");
		}
		catch (NullPointerException e)
		{
			throw new ImmobilieException("Fehler: keine Datei!");
		}
	}
	
	public void importImmobilie(String filename) throws ImmobilieException
	{
		try
		{
			String zeile;
			FileReader fileReader = new FileReader(filename);
			BufferedReader bufferedReader = new BufferedReader(fileReader);
			zeile = bufferedReader.readLine();
			while (zeile != null)
			{
				if (zeile.startsWith("Grundstuck"))
				{
					Grundstuck grundstuck = new Grundstuck(zeile);
					aufnehmen(grundstuck);
				}
				else
				{
					if (zeile.startsWith("Wohnung"))
					{
						Wohnung wohnung = new Wohnung(zeile);
						aufnehmen(wohnung);
					}
					else
					{
						if (zeile.startsWith("Balkon"))
						{
							WohnungBalkon wohnungBalkon = new WohnungBalkon(zeile);
							aufnehmen(wohnungBalkon);
						}
						else
						{
							throw new ImmobilieException("Fehler: ungültiges Objekt!");
						}
					}
				}
				zeile = bufferedReader.readLine();
			}
			bufferedReader.close();
			fileReader.close();
		}
		catch (FileNotFoundException e)
		{
			throw new ImmobilieException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new ImmobilieException("Fehler: Datei konnte nicht gelesen werden!");
		}
		catch (NullPointerException e)
		{
			throw new ImmobilieException("Fehler: keine Datei!");
		}
	}
	
	public void loadImmobilie(String filename) throws ImmobilieException
	{
		try
		{
			FileInputStream fileInputStream = new FileInputStream(filename);
			ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
			immobilien = (ArrayList<Immobilie>) objectInputStream.readObject();
			objectInputStream.close();
			fileInputStream.close();
		}
		catch (FileNotFoundException e)
		{
			throw new ImmobilieException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new ImmobilieException("Fehler: Datei konnte nicht gelesen werden!");
		}
		catch (ClassNotFoundException e)
		{
			throw new ImmobilieException("Fehler: Datei enthält ungültige Daten!");			
		}
		catch (NullPointerException e)
		{
			throw new ImmobilieException("Fehler: keine Datei!");
		}
	}
	
	public void saveImmobilie(String filename) throws ImmobilieException
	{
		try
		{
			FileOutputStream fileOutputStream = new FileOutputStream(filename);
			ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
			objectOutputStream.writeObject(immobilien);
			objectOutputStream.close();
			fileOutputStream.close();
		}
		catch (FileNotFoundException e)
		{
			throw new ImmobilieException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new ImmobilieException("Fehler: Datei konnte nicht geschrieben werden!");
		}
		catch (NullPointerException e)
		{
			throw new ImmobilieException("Fehler: keine Datei!");
		}		
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = firma + "\n\n";
		for (Immobilie immo: immobilien)
		{
			erg += immo.toString() + "\n";
		}
		return erg;
	}

	public String toStringCSV()
	{
		String erg;
		
		erg = "";
		for (Immobilie immo: immobilien)
		{
			erg += immo.toStringCSV() + "\n";
		}
		return erg;
	}
}













