package model;

public class Grundstuck extends Immobilie
{
	private boolean bebaubar;
	
	public Grundstuck(String zeile) throws ImmobilieException
	{
		super(zeile);
		try
		{
			String[] teile;
			teile = zeile.split(";");
			if (teile[4].trim().charAt(0) == 'B')
				setBebaubar(true);
			else
				setBebaubar(false);				
		}
		catch (NumberFormatException | IndexOutOfBoundsException e)
		{
			throw new ImmobilieException("Fehler: ungültiges Format!");
		}	
	}
	
	public Grundstuck(String ort, char lage, int mm, boolean bebaubar) throws ImmobilieException
	{
		super(ort, lage, mm);
		setBebaubar(bebaubar);
	}

	public void setMm(int mm) throws ImmobilieException
	{
		if (mm >= 300)
		{
			this.mm = mm;
		}
		else
		{
			throw new ImmobilieException("Fehler: mind. 300m²");
		}
	}
	
	public boolean getBebaubar()
	{
		return bebaubar;
	}
	
	public void setBebaubar(boolean bebaubar)
	{
		this.bebaubar = bebaubar;
	}
	
	@Override
	public String toStringCSV()
	{
		if (bebaubar)
			return "Grundstuck;" + super.toStringCSV() + ";B";
		else
			return "Grundstuck;" + super.toStringCSV() + ";G";
	}
	
	@Override
	public String toString()
	{
		if (bebaubar == true)
		{
			return "Grund: " + super.toString() + " " + mm + "m² " + "BAUFLÄCHE";
		}
		else
		{
			return "Grund: " + super.toString() + " " + mm + "m² " + "GRÜNFLÄCHE";			
		}
	}
	
	@Override
	public double getPreis()
	{
		//      Bau  Grün
		//t ... 600  100
		//n ... 300   20
		//s ... 100    5
		if (bebaubar == true)
		{
			if (getLage() == 't')
			{
				return 600*mm;
			}
			else
			{
				if (getLage() == 'n')
				{
					return 300*mm;
				}
				else
				{
					return 100*mm;
				}
			}
		}
		else
		{
			if (getLage() == 't')
				return 100*mm;
			if (getLage() == 'n')
				return 20*mm;
			return 5*mm;			
		}
	}	
}







