package test;

import model.FahrzeugException;
import model.Firma;
import model.MietAuto;

public class TestFirma
{

	public static void main(String[] args)
	{
		testImportExport();
	}

	public static void testImportExport()
	{
		Firma f;
		
		f = new Firma();
		try
		{
			f.importFahrzeuge("gibtesnicht.txt");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			f.importFahrzeuge("fahrzeug.txt");
			System.out.println(f);
			f.exportFahrzeuge("fahrzeug2.txt");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}

	public static void testAusborgen()
	{
		MietAuto m0, m1, m2, m3, m4, m5;
		Firma f;

		try
		{
			f = new Firma();
			m0 = new MietAuto(40001, false,  850);
			m1 = new MietAuto(35000, false,  1050);
			m2 = new MietAuto(30001, true,  702);
			m3 = new MietAuto(4000, true,   543);
			m4 = new MietAuto(35000, true,   827);
			m5 = new MietAuto(1000, false,  942);
			f.kaufen(m0);
			f.kaufen(m1);
			f.kaufen(m2);
			f.kaufen(m3);
			f.kaufen(m4);
			f.kaufen(m5);
			System.out.println(f);
			f.ausborgen(3, 9900);
			System.out.println(f);
			f.ausborgen(1,    5);
			System.out.println(f);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}		
	}

	public static void testVerkaufeAlteFahrzeuge()
	{
		MietAuto m0, m1, m2, m3, m4, m5;
		Firma f;

		try
		{
			f = new Firma();
			m0 = new MietAuto(40001, false,  850);
			m1 = new MietAuto(35000, false,  1050);
			m2 = new MietAuto(30001, true,  702);
			m3 = new MietAuto(4000, true,   543);
			m4 = new MietAuto(35000, true,   827);
			m5 = new MietAuto(1000, false,  942);
			f.verkaufeAlteFahrzeuge();
			System.out.println("=================");
			System.out.println(f);
			System.out.println("=================");
			f.kaufen(m0);
			f.kaufen(m1);
			f.kaufen(m2);
			f.kaufen(m3);
			f.kaufen(m4);
			f.kaufen(m5);
			System.out.println("=================");
			System.out.println(f);                        // 40001 35000 30001 4000 35000 1000
			System.out.println("=================");
			f.verkaufeAlteFahrzeuge();
			System.out.println("=================");
			System.out.println(f);                        // 35000 4000 1000
			System.out.println("=================");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}	
	}

	public static void testAnzahlCabrio()
	{
		MietAuto m0, m1, m2, m3, m4, m5;
		Firma f;

		try
		{
			f = new Firma();
			m0 = new MietAuto(5000, false,  850);
			m1 = new MietAuto(6000, true,  1050);
			m2 = new MietAuto(9000, false,  702);
			m3 = new MietAuto(4000, true,   543);
			m4 = new MietAuto(2000, true,   827);
			m5 = new MietAuto(1000, false,  942);
			System.out.println(f.anzahlCabrio());     // 0
			f.kaufen(m0);
			System.out.println(f.anzahlCabrio());     // 0
			f.kaufen(m1);
			f.kaufen(m2);
			System.out.println(f.anzahlCabrio());     // 1
			f.kaufen(m3);
			f.kaufen(m4);
			f.kaufen(m5);
			System.out.println(f.anzahlCabrio());     // 3
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	
	}

	public static void testKaufen()
	{
		MietAuto m0, m1, m2, m3, m4, m5;
		Firma f;

		try
		{
			f = new Firma();
			f.kaufen(null);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());      // kein Fahrzeug
		}

		try
		{
			f = new Firma();
			m0 = new MietAuto(5000, false,  850);
			f.kaufen(m0);
			f.kaufen(m0);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());      // schon vorhanden
		}

		
		try
		{
			f = new Firma();
			m0 = new MietAuto(5000, false,  850);
			m1 = new MietAuto(6000, true,  1050);
			m2 = new MietAuto(9000, false,  702);
			m3 = new MietAuto(4000, true,   543);
			m4 = new MietAuto(2000, true,   827);
			m5 = new MietAuto(1000, false,  942);
			f.kaufen(m0);
			f.kaufen(m1);
			f.kaufen(m2);
			f.kaufen(m3);
			f.kaufen(m4);
			f.kaufen(m5);
			System.out.println(f);                    //5000 6000 9000 4000 2000 1000
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
}
