package model;

public class MietAuto extends Fahrzeug
{
	private static double maxPreisMonat = 1500;
	
	private boolean       cabrio;
	private double        preisMonat;
	
	public MietAuto(String zeile) throws FahrzeugException
	{
		//MietAuto;3800;N;780.50
		super(zeile);
		
		String[] daten;
		
		try
		{
			daten = zeile.split(";");
			if (daten[2].equals("C"))
				setCabrio(true);
			else
				setCabrio(false);
			setPreisMonat(Double.parseDouble(daten[3]));
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FahrzeugException("Fehler: zu wenig Eigenschaften angegeben!");
		}
		catch (NumberFormatException e)
		{
			throw new FahrzeugException("Fehler: kein gültiger Preis pro Monat!");	
		}
		
		
	}
	
	public MietAuto(int km, boolean cabrio, double preisMonat) throws FahrzeugException
	{
		super(km);
		setCabrio(cabrio);
		setPreisMonat(preisMonat);
	}
	
	public double ausborgen(int monate, int km)
	{
		setKm(getKm() + km);
		return monate * preisMonat;
	}
	
	// über 40 000 km => ALTES FAHRZEUG!!!
	// bei Cabrio 30 000 km => ALTES FAHRZEUG!!!
	public boolean isAltesFahrzeug()
	{
		if (cabrio)
			if (getKm() > 30000)
				return true;
			else
				return false;
		else
			if (getKm() > 40000)
				return true;
			else
				return false;
	}

	public boolean isCabrio()
	{
		return cabrio;
	}
	
	public void setCabrio(boolean cabrio)
	{
		this.cabrio = cabrio;
	}
	
	public double getPreisMonat()
	{
		return preisMonat;
	}
	
	public void setPreisMonat(double preisMonat) throws FahrzeugException
	{
		if ((preisMonat >= 300) && (preisMonat <= maxPreisMonat))
		{
			this.preisMonat = preisMonat;
		}
		else
		{
			throw new FahrzeugException("Fehler: ungültiger Preis!");
		}
	}

	@Override
	public String toString()
	{
		if (cabrio)
		{
			return super.toString() + " Cabrio EUR/Monat: " + preisMonat;
		}
		else
		{
			return super.toString() + " Regulär EUR/Monat: " + preisMonat;
		}
	}
	
	@Override
	public String toStringCSV()
	{
		if (cabrio)
			return super.toStringCSV() + ";C;" + preisMonat; 
		else
			return super.toStringCSV() + ";N;" + preisMonat; 				
	}
}














