package model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Firma
{
	private double              kassa;
	private ArrayList<Fahrzeug> fahrzeuge;
	
	public Firma()
	{
		setKassa(0);
		fahrzeuge = new ArrayList<>();
	}
	
	public void exportFahrzeuge(String filename) throws FahrzeugException
	{
		try
		{
			FileWriter fw = new FileWriter(filename);
			BufferedWriter bw = new BufferedWriter(fw);
			
			bw.write(toStringCSV());
			
			bw.close();
			fw.close();
		}
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new FahrzeugException("Fehler: Datei konnte nicht geschrieben werden!");
		}
	}
	
	public void importFahrzeuge(String filename) throws FahrzeugException
	{
		try
		{
			String zeile;
			FileReader fr = new FileReader(filename);
			BufferedReader br = new BufferedReader(fr);
			
			zeile = br.readLine();
			while (zeile != null)
			{
				if (zeile.startsWith("MietAuto"))
				{
					//kaufen(new MietAuto(zeile));
					MietAuto m;
					m = new MietAuto(zeile);
					kaufen(m);
				}
				zeile = br.readLine();				
			}
			
			br.close();
			fr.close();
		}
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: ungültiger Dateiname!");
		}
		catch (IOException e)
		{
			throw new FahrzeugException("Fehler: keinen Zugriff auf die Daten!");
		}
	}
	
	public void ausborgen(int monate, int km) throws FahrzeugException
	{
		boolean gefunden;
		double geld;
		MietAuto m;
		Fahrzeug f;
		Iterator<Fahrzeug> it;
		
		gefunden = false;
		it = fahrzeuge.iterator();
		while ((it.hasNext()) && ( ! gefunden))
		{
			f = it.next();
			if (f instanceof MietAuto)
			{
				m = (MietAuto) f;
				geld = m.ausborgen(monate, km);
				setKassa(kassa+geld);
				gefunden = true;
			}
		}
		if ( ! gefunden)
		{
			throw new FahrzeugException("Fehler: kein Mietfahrzeug zur Verfügung!");
		}
	}
	
	public double getKassa()
	{
		return kassa;
	}

	public void setKassa(double kassa)
	{
		this.kassa = kassa;
	}
	
	public void kaufen(Fahrzeug neu) throws FahrzeugException
	{
		if (neu != null)
		{
			if ( ! (fahrzeuge.contains(neu)))
			{
				fahrzeuge.add(neu);
			}
			else
			{
				throw new FahrzeugException("Fehler: schon vorhanden!");
			}
		}
		else
		{
			throw new FahrzeugException("Fehler: kein Fahrzeug!");
		}
	}
	
	public void verkaufeAlteFahrzeuge()
	{
		Fahrzeug f;
		Iterator<Fahrzeug> it;
		
		it = fahrzeuge.iterator();
		while (it.hasNext())
		{
			f = it.next();
			if (f.isAltesFahrzeug())
				it.remove();
		}
	}
	
	public int anzahlCabrio()
	{
		MietAuto m;
		int anz;
		
		anz = 0;
		for (Fahrzeug f: fahrzeuge)
		{
			if (f instanceof MietAuto)
			{
				m = (MietAuto)f;
				if (m.isCabrio())
					anz++;
			}
		}
		return anz;
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = "Kassa: " + kassa + "\n";
		for (Fahrzeug f: fahrzeuge)
		{
			erg += f.toString() + "\n";
		}
		return erg;
	}

	public String toStringCSV()
	{
		String erg;
		
		erg = "";
		for (Fahrzeug f: fahrzeuge)
		{
			erg += f.toStringCSV() + "\n";
		}
		return erg;
	}
}





















