package model;

public abstract class Fahrzeug
{
	private static int nextId = 10000;
	private int        fahrzeugId;
	private int        km;

	public Fahrzeug(String zeile) throws FahrzeugException
	{
		//MietAuto;3800;N;780.50
		String[] daten;
		
		try
		{
			setFahrzeugId();
			daten = zeile.split(";");
			setKm(Integer.parseInt(daten[1]));
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FahrzeugException("Fehler: kein KM Stand vorhanden!");
		}
		catch (NumberFormatException e)
		{
			throw new FahrzeugException("Fehler: kein gültiger KM Stand!");			
		}
	}
	
	public Fahrzeug(int km)
	{
		super();
		setFahrzeugId();
		setKm(km);
	}
	
	public int getFahrzeugId()
	{
		return fahrzeugId;
	}

	private void setFahrzeugId()
	{
		this.fahrzeugId = nextId;
		nextId++;
	}
	
	
	public int getKm()
	{
		return km;
	}

	public void setKm(int km)
	{
		this.km = km;
	}
	
	@Override
	public String toString()
	{
		return fahrzeugId + ":   " + getClass().getSimpleName() + " " + km + " km Stand ";
	}
	
	public String toStringCSV()
	{
		return getClass().getSimpleName() + ";" + km;
	}	

	public abstract boolean isAltesFahrzeug();
}








