package model;

public class MietAuto extends Fahrzeug
{
	private static double maxPreisMonat = 1500;
	
	private boolean       cabrio;
	private double        preisMonat;
	
	public MietAuto(int km, boolean cabrio, double preisMonat) throws FahrzeugException
	{
		super(km);
		setCabrio(cabrio);
		setPreisMonat(preisMonat);
	}
	
	// über 40 000 km => ALTES FAHRZEUG!!!
	// bei Cabrio 30 000 km => ALTES FAHRZEUG!!!
	public boolean isAltesFahrzeug()
	{
		if (cabrio)
			if (getKm() > 30000)
				return true;
			else
				return false;
		else
			if (getKm() > 40000)
				return true;
			else
				return false;
	}

	public boolean isCabrio()
	{
		return cabrio;
	}
	
	public void setCabrio(boolean cabrio)
	{
		this.cabrio = cabrio;
	}
	
	public double getPreisMonat()
	{
		return preisMonat;
	}
	
	public void setPreisMonat(double preisMonat) throws FahrzeugException
	{
		if ((preisMonat >= 300) && (preisMonat <= maxPreisMonat))
		{
			this.preisMonat = preisMonat;
		}
		else
		{
			throw new FahrzeugException("Fehler: ungültiger Preis!");
		}
	}

	@Override
	public String toString()
	{
		if (cabrio)
		{
			return super.toString() + " Cabrio EUR/Monat: " + preisMonat;
		}
		else
		{
			return super.toString() + " Regulär EUR/Monat: " + preisMonat;
		}
	}
	
	
}
