package model;

import java.util.ArrayList;
import java.util.Iterator;

public class Firma
{
	private ArrayList<Fahrzeug> fahrzeuge;
	
	public Firma()
	{
		fahrzeuge = new ArrayList<>();
	}
	
	public void kaufen(Fahrzeug neu) throws FahrzeugException
	{
		if (neu != null)
		{
			if ( ! (fahrzeuge.contains(neu)))
			{
				fahrzeuge.add(neu);
			}
			else
			{
				throw new FahrzeugException("Fehler: schon vorhanden!");
			}
		}
		else
		{
			throw new FahrzeugException("Fehler: kein Fahrzeug!");
		}
	}
	
	public void loschenAlteFahrzeuge()
	{
		Fahrzeug f;
		Iterator<Fahrzeug> it;
		
		it = fahrzeuge.iterator();
		while (it.hasNext())
		{
			f = it.next();
			if (f.isAltesFahrzeug())
			{
				it.remove();
			}
		}
	}
	
	public int anzahlCabrio()
	{
		MietAuto m;
		int anz;
		
		anz = 0;
		for (Fahrzeug f: fahrzeuge)
		{
			if (f instanceof MietAuto)
			{
				m = (MietAuto)f;
				if (m.isCabrio())
					anz++;
			}
		}
		return anz;
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = "";
		for (Fahrzeug f: fahrzeuge)
		{
			erg += f.toString() + "\n";
		}
		return erg;
	}
}





















