package model;

public abstract class Fahrzeug
{
	private static int nextId = 10000;
	private int        fahrzeugId;
	private int        km;

	public Fahrzeug(int km)
	{
		super();
		setFahrzeugId();
		setKm(km);
	}
	
	public int getFahrzeugId()
	{
		return fahrzeugId;
	}

	private void setFahrzeugId()
	{
		this.fahrzeugId = nextId;
		nextId++;
	}
	
	
	public int getKm()
	{
		return km;
	}

	public void setKm(int km)
	{
		this.km = km;
	}

	public abstract boolean isAltesFahrzeug();
	
	@Override
	public String toString()
	{
		return fahrzeugId + ":   " + getClass().getSimpleName() + " " + km + " km Stand ";
	}
	
	
}
