package model;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Fuhrpark
{
	private ArrayList<Fahrzeug> fahrzeuge;
	
	public Fuhrpark()
	{
		fahrzeuge = new ArrayList<>(20);
	}
	
	public void kaufen(Fahrzeug f) throws FahrzeugException
	{
		if (f != null)
		{
			if (fahrzeuge.contains(f) == false)
			{
				fahrzeuge.add(f);
			}
			else
			{
				throw new FahrzeugException("Schon gekauft!");
			}
		}
		else
		{
			throw new FahrzeugException("kein Fahrzeug!");
		}
	}
	
	public void losche(int minSitzanzahl)
	{
		Iterator<Fahrzeug> it;
		Fahrzeug f;
		Autobus a;
		
		it = fahrzeuge.iterator();
		while (it.hasNext())
		{
			f = it.next();
			if (f instanceof Autobus)
			{
				a = (Autobus)f;
				if (a.getSitzanzahl() < minSitzanzahl)
				{
					it.remove();
				}
			}
		}
	}
	
	public void exportFahrzeuge(String filename) throws FahrzeugException
	{
		FileWriter fw;
		try
		{
			if (filename!=null)
			{
				fw = new FileWriter(filename);
				BufferedWriter bw = new BufferedWriter(fw);
				bw.write(toString());
				bw.close();
				fw.close();
			}
			else
				throw new FahrzeugException("Fehler: kein Dateiname!");				
		}
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new FahrzeugException("Fehler: Daten konnten nicht geschrieben werden!");
		}
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = "";
		for (Fahrzeug f: fahrzeuge)
		{
			erg += f.toString() + "\n";
		}
		return erg;
	}
}
