package model;

public abstract class Fahrzeug
{
	private static int lastID=100;
	private int fahrzeugID;
	private boolean boardservice;
	
	public Fahrzeug(boolean boardservice)
	{
		setFahrzeugID();
		setBoardservice(boardservice);
	}

	public int getFahrzeugID()
	{
		return fahrzeugID;
	}

	public void setFahrzeugID()
	{
		this.fahrzeugID = lastID;
		lastID++;
	}
	
	public boolean isBoardservice()
	{
		return boardservice;
	}
	
	public void setBoardservice(boolean boardservice)
	{
		this.boardservice = boardservice;
	}
	
	@Override
	public String toString()
	{
		//100 (mit Boardservice) Autobus 50 Sitze
		//101 (ohne Boardservice) Autobus 40 Sitze
		String erg;
		
		erg = "" + fahrzeugID;
		if (boardservice)
		{
			erg += " (mit Boardservice) ";
		}
		else
		{
			erg += " (ohne Boardservice) ";
		}
		erg += getClass().getSimpleName();
		return erg;
	}
	
	public abstract int getMietpreis(int km);
}
