package model;

public class Autobus extends Fahrzeug
{
	private int sitzanzahl;

	public Autobus(boolean boardservice, int sitzanzahl) throws FahrzeugException
	{
		super(boardservice);
		setSitzanzahl (sitzanzahl);
	}

	public int getSitzanzahl()
	{
		return sitzanzahl;
	}

	public void setSitzanzahl(int sitzanzahl) throws FahrzeugException
	{
		if ((sitzanzahl >= 20) && (sitzanzahl <= 80))
			this.sitzanzahl = sitzanzahl;
		else
			throw new FahrzeugException("Fehler: ungültige Sitzanzahl!");
	}
	
	public int getMietpreis(int km)
	{
		if (isBoardservice())
			return 150 + (10*km) + 100;
		else
			return 150 + (10*km);
	}
	
	@Override
	public String toString()
	{
		//100 (mit Boardservice) Autobus 50 Sitze
		//101 (ohne Boardservice) Autobus 40 Sitze
		String erg;
		
		erg = super.toString() + " " + sitzanzahl + " Sitze";
		return erg;
	}
}
