public abstract class Student implements Comparable<Student>
{
	private static int lastid=1000;
	private int studentid;
    private int alter;
    private String name;
    private School school;
    
	public Student(String name, int alter) throws StudentException
    {
    	setStudentid();
        setName(name);
        setAlter(alter);
    }
    
    public Student(String name) throws StudentException
    {
    	setStudentid();
        setName(name);
        setAlter(13);
    }
    
    public Student(int alter) throws StudentException
    {
    	setStudentid();
        setName("Unkn");
        setAlter(alter);
    }
    
    public Student() throws StudentException
    {
    	setStudentid();
        setName("Unkn");
        setAlter(13);
    }
    
    public int getAlter()
    {
        return alter;
    }

    
    public int getStudentid()
	{
		return studentid;
	}

    public static int getLastid()
    {
    	return Student.lastid;
    }
    
    public String getName()
    {
        return name;
    }
    
    public School getSchool()
    {
        return school;
    }

    public void setName(String name) throws StudentException
    {
        if ((name != null) && (name.length()>0))
        {
            this.name = name;
        }
        else
        {
            throw new StudentException("Fehler: kein Name!");
        }
    }
    
    public void setAlter(int alter) throws StudentException
    {
    	if ((alter >= 12) && (alter <= 55))
    	{
    		this.alter = alter;
    	}
    	else
    	{
    		throw new StudentException("Fehler: ungültiges Alter!");
    	}
    }
    
    public void setSchool(School school)
    {
        this.school = school;
    }

	private void setStudentid()
	{
		Student.lastid++;
		this.studentid = Student.lastid;
	}

    public String toString()
    {
    	return studentid + "   " + name + " (" + alter + " Jahre)";
    }
    
    public String getInitialen()
    {
        if (name.contains(" ") == true)
        {
            return "" + name.charAt(0) + name.charAt(name.indexOf(' ')+1);
        }
        else
        {
            return "" + name.charAt(0);
        }
    }
    
    public String getAccount() throws StudentException
    {
        //01234567890123456789
        //Thomas Griesmayer
        String account;
        
        try
        {
        	account = name.substring(0,2);
        	account = account + name.substring(name.indexOf(' '), name.indexOf(' ')+6) + alter;
        	return account.toUpperCase();
        }
        catch (IndexOutOfBoundsException e)
        {
        	throw new StudentException("Fehler: ungültiger Name!");
        }
    }
    
    public void abmelden() throws StudentException
    {
        if (school != null)
        {
            school.abmelden(this);
        }
        else
        {
            throw new StudentException("Fehler: in keiner Schule angemeldet!");
        }
    }
    
    public int compareTo(Student other)
    {
    	//this.name < == > other.getName()
    	//return this.name.compareTo(other.getName());
    	// this.alter < == > other.getAlter()
    	return this.alter - other.getAlter();
    }
    
    public abstract double uberweisen();
    
    /*
    public void testen()
    {
        System.out.println(name.length());
        System.out.println(name.charAt(0));
        System.out.println(name.indexOf(' '));
        System.out.println(name.charAt(name.indexOf(' ')+1));
    }
    */
}



















