package model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;

public class Firma
{
	private String firmenName;
	private ArrayList<Mitarbeiter> mitarbeiter;

	public Firma(String firmenName)
	{
		setFirmenName(firmenName);
		mitarbeiter = new ArrayList<Mitarbeiter>(20);
	}

	public String getFirmenName()
	{
		return firmenName;
	}

	public void setFirmenName(String firmenName)
	{
		if (firmenName != null)
		{
			this.firmenName = firmenName;
		}
		else
		{
			System.out.println("Fehler: ungültiger Firmenname!");
			this.firmenName = "UNKN";
		}
	}
	
	/* Falsche Schleife !!!
	public void kundigen(String name)
	{
		if (name != null)
		{
			for (Mitarbeiter m: mitarbeiter)
			{
				if (m.getName().equals(name))
				{
					mitarbeiter.remove(m);
				}
			}
		}
		else
		{
			System.out.println("Fehler: kein gültiger Name!");
		}
	}*/
	
	public void kundigen(String name)
	{
		Mitarbeiter m;
		Iterator<Mitarbeiter> it;
		
		if (name != null)
		{
			it = mitarbeiter.iterator();
			while (it.hasNext())
			{
				m = it.next();
				if (m.getName().equals(name))
				{
					it.remove();
				}
			}
		}
		else
		{
			System.out.println("Fehler: kein gültiger Name!");
		}
	}
	
	public Arbeiter getErsterArbeiter()
	{
		for (Mitarbeiter m : mitarbeiter)
		{
			if (m instanceof Arbeiter)
			{
				return (Arbeiter) m;
			}
		}
		return null;
	}
	
	public void aufnehmen(Mitarbeiter neu)
	{
		if (neu != null)
		{
			//if (!mitarbeiter.contains(neu))
			if (mitarbeiter.contains(neu) == false)
			{
				mitarbeiter.add(neu);
			}
			else
			{
				System.out.println("Fehler: Mitarbeiter schon in dieser Firma!");
			}
		}
		else
		{
			System.out.println("Fehler: kein Mitarbeiter!");
		}
	}

	public double berechneGehaltTotal()
	{
		double sum;
		
		sum = 0;
		for (Mitarbeiter m: mitarbeiter)
		{
			sum = sum + m.berechneGehalt();
		}
		return sum;
	}
	
	public double berechneFrauenQuote()
	{
		int anz;
		
		anz = 0;
		for (Mitarbeiter m: mitarbeiter)
		{
			if (m.getGesch() == 'f')
			{
				anz++;
			}
		}
		return (double)anz*100/mitarbeiter.size();
	}
	
	public Mitarbeiter alterMitarbeiter()
	{
		int jahr;
		Mitarbeiter alter;
		
		jahr = 9999;
		alter = null;
		for (Mitarbeiter m: mitarbeiter)
		{
			if (jahr > m.getGeb())
			{
				jahr = m.getGeb();
				alter = m;
			}
		}
		return alter;
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = "Firma: " + firmenName + "\n";
		for (Mitarbeiter m: mitarbeiter)
		{
			erg = erg + m.toString() + "\n";
		}
		return erg;
	}
	
	public void sortName()
	{
		Collections.sort(mitarbeiter);
	}
}














