public class Oldtimer extends Fahrzeug
{
    private boolean originalzustand;

    public Oldtimer(String kennzeichen, int baujahr, double preis, boolean originalzustand)
    {
        super(kennzeichen, baujahr, preis);
        setOriginalzustand(originalzustand);
        setPreis(preis);
    }

    @Override
    public void setPreis(double preis)
    {
        if (
                ((originalzustand == true)  && (preis >= 20000)) ||
                ((originalzustand == false) && (preis >= 10000)))
        {
            this.preis = preis;
        }
        else
        {
            System.out.println("Fehler: ungültiger Preis");
            this.preis = 25000;
        }
    }

    @Override
    public void setBaujahr(int baujahr)
    {
        if ((baujahr >= 1886) && (baujahr <= 1944))
        {
            this.baujahr = baujahr;
        }
        else
        {
            System.out.println("Fehler: ungültiges Baujahr");
            this.baujahr = 1944;
        }
    }

    public boolean isOriginalzustand()
    {
        return originalzustand;
    }

    public void setOriginalzustand(boolean originalzustand)
    {
        this.originalzustand = originalzustand;
    }

    @Override
    public String toString()
    {
        if (originalzustand)
        {
            return super.toString() + " - ORIGINAL";
        }
        else
        {
            return super.toString() + " - kein original Zustand";
        }
    }
}
