public abstract class Fahrzeug
{
    private   String kennzeichen;
    protected int    baujahr;
    protected double preis;

    public Fahrzeug(String kennzeichen, int baujahr, double preis)
    {
        setKennzeichen(kennzeichen);
        setBaujahr(baujahr);
        //setPreis(preis);
    }

    public String getKennzeichen()
    {
        return kennzeichen;
    }

    public void setKennzeichen(String kennzeichen)
    {
        this.kennzeichen = kennzeichen;
    }

    public int getBaujahr()
    {
        return baujahr;
    }

    public void setBaujahr(int baujahr)
    {
        if ((baujahr >= 1886) && (baujahr <= 2024))
        {
            this.baujahr = baujahr;
        }
        else
        {
            System.out.println("Fehler: ungültiges Baujahr");
            this.baujahr = 2024;
        }
    }

    public double getPreis()
    {
        return preis;
    }

    public abstract void setPreis(double preis);

    @Override
    public String toString()
    // WN-3495W 2019 800.0 Euro
    {
        return kennzeichen + " " + baujahr + " " + preis + " Euro";
    }
}
