public class Auto
{
	private static int lastId=100;
	private int autoId;
    private String kennzeichen;
    private int baujahr;
    private boolean automatik;
    private Parkplatz parkplatz;

    public Auto(String kennzeichen, int baujahr, boolean automatik) throws AutoException
    {
    	setAutoId();
        setKennzeichen(kennzeichen);
        setAutomatik(automatik);
        setBaujahr(baujahr);
    }

    public Auto(String kennzeichen) throws AutoException
    {
    	setAutoId();
        setKennzeichen(kennzeichen);
        setAutomatik(false);
        setBaujahr(2007);
    }

    public Auto(String kennzeichen, boolean automatik) throws AutoException
    {
    	setAutoId();
        setKennzeichen(kennzeichen);
        setAutomatik(automatik);
        setBaujahr(2007);
    }

    public Auto() throws AutoException
    {
    	setAutoId();
        setKennzeichen("BMW");
        setAutomatik(false);        
        setBaujahr(2007);
    }

    public int getAutoId()
    {
    	return autoId;
    }
    
    public String getKennzeichen()
    {
        return kennzeichen;
    }

    public int getBaujahr()
    {
        return baujahr;
    }

    public boolean getAutomatik()
    {
        return automatik;
    }
    
    public String getOrt()
    {
        //01234567
        //WN-123W
        //WN
        //2
        return kennzeichen.substring(0, kennzeichen.indexOf('-'));
    }
    
    public String getNummer() throws AutoException
    {
    	//01234567
    	//WWWWW-
    	//5+2 = 7
    	//ab der Position 7
    	try
    	{
    		return kennzeichen.substring(kennzeichen.indexOf('-')+2);
    	}
    	catch (IndexOutOfBoundsException e)
    	{
    		throw new AutoException("Fehler: ungültige Autonummer!");
    	}
    }

    public Parkplatz getParkplatz()
    {
        return parkplatz;
    }
    
    public static int getLastId()
    {
    	return Auto.lastId;
    }
    
    public void setAutoId()
    {
    	lastId++;
    	autoId = lastId;
    }

    public void setKennzeichen(String kennzeichen) throws AutoException
    {
        if ((kennzeichen != null) && (kennzeichen.length() >= 5) && (kennzeichen.contains("-") == true))
        {
            this.kennzeichen = kennzeichen.toUpperCase();
        }
        else
        {
        	throw new AutoException("Fehler: kein Kennzeichen!");
        }
    }

    public void setBaujahr(int baujahr) throws AutoException
    {
        if (automatik == true)
        {
            //1985..2017
            if ((baujahr>=1985) && (baujahr<=2017))
            {
                this.baujahr = baujahr;
            }
            else
            {
                if (baujahr<1985)
                {
                    //zu klein
                	throw new AutoException("Fehler: Automatik Autos gibt erst ab dem Baujahr 1985!");
                }
                else
                {
                    //zu groß
                	throw new AutoException("Fehler: Automatik Autos gibt bis zum Baujahr 2017!");
                }
            }
        }
        else
        {
            //1960..2007
            if ((baujahr>=1960) && (baujahr<=2007))
            {
                this.baujahr = baujahr;
            }
            else
            {
                if (baujahr<1960)
                {
                    //zu klein
                	throw new AutoException("Fehler: Autos mit Schaltung gibt es ab dem Baujahr 1960!");
                }
                else
                {
                    //zu groß
                	throw new AutoException("Fehler: Autos mit Schaltung gibt bis zum Baujahr 2007!");
                }
            }
        }
    }

    public void setAutomatik(boolean automatik)
    {
        this.automatik = automatik;
    }
    
    public void setParkplatz(Parkplatz parkplatz)
    {
        this.parkplatz = parkplatz;
    }

    public String toString()
    {
        if (automatik == true)
        {
            return autoId + ": " + kennzeichen + " - " + baujahr + " (AUTOMATIK)";
        }
        else
        {
            return autoId + ": " + kennzeichen + " - " + baujahr + " (kein AUTOMATIK)";
        }
    }
    
    public void ausparken() throws AutoException
    {
        if (parkplatz != null)
        {
            parkplatz.ausparken(this);
        }
        else
        {
            throw new AutoException("Fehler: stehe auf keinem Parkplatz!");
        }
    }
}











