import java.util.*;

public class Parkplatz
{
    private ArrayList<Auto> platze;

    public Parkplatz()
    {
        Auto a;

        platze = new ArrayList<Auto>();
    }

    public void ausparken(String ort)
    {
        Iterator<Auto> it;
        Auto a;
        
        if (ort != null)
        {
            it = platze.iterator();
            while (it.hasNext())
            {
                a = it.next();
                if (a.getKennzeichen().startsWith(ort))
                {
                    it.remove();
                    a.setParkplatz(null);
                }
            }
        }
        else
        {
            System.out.println("Fehler: kein Ort!");
        }
    }
    
    public void einparken(Auto neu)
    {
        if (neu != null)
        {
            if (platze.size() < 5)
            {
                platze.add(neu);
                neu.setParkplatz(this);
            }
            else
            {
                System.out.println("Fehler: kein Platz mehr!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Auto!");
        }
    }

    public String toString()
    {
        String erg;

        erg = "";
        for (Auto a: platze)
        {
            erg = erg + a.toString() + "\n";
        }
        return erg;
    }

    public int anzahlAutomatik()
    {
        int anz;

        anz = 0;
        for (Auto a: platze)
        {
            if (a.getAutomatik() == true)
            {
                anz++;
            }
        }
        return anz;
    }

    public double avgBaujahrAutomatik()
    {
        int sum;
        int anz;

        sum=0;
        anz=0;
        for (Auto a: platze)
        {
            if (a.getAutomatik() == true)
            {
                sum += a.getBaujahr();
                anz++;
            }
        }
        if (anz > 0)
        {
            return (double)sum/anz;
        }
        else
        {
            System.out.println("Fehler: kein automatik Auto!");
            return 0;
        }
    }

    public int minBaujahr()
    {
        int min;

        min = 9999;
        for (Auto a: platze)
        {
            if (a.getBaujahr() < min)
            {
                min = a.getBaujahr();
            }
        }
        return min;
    }

    public void ausparken(Auto wer)
    {
        if (wer != null)
        {
            if (platze.remove(wer)) /* == true */
            {
                wer.setParkplatz(null);
            }
            else
            {
                System.out.println("Fehler: Auto nicht am Parkplatz!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Auto!");
        }
    }
}






