import java.time.LocalDate;

public class AktienKurs
{
    private int anzahl;
    private LocalDate datum;
    private double kurs;
    
    public AktienKurs(int anzahl, int jahr, int monat, int tag, double kurs)
    {
        setAnzahl(anzahl);
        setDatum(LocalDate.of(jahr, monat, tag));
        setKurs(kurs);
    }
    
    public int getAnzahl()
    {
        return anzahl;
    }
    
    public LocalDate getDatum()
    {
        return datum;
    }
    
    public double getKurs()
    {
        return kurs;
    }

    public void setAnzahl(int anzahl)
    {
        if (anzahl >= 0)
        {
            this.anzahl = anzahl;
        }
        else
        {
            System.out.println("Fehler: keine gültige Anzahl!");
            this.anzahl = 0;
        }
    }
    
    public void setDatum(LocalDate datum)
    {
        if (datum != null)
        {
            this.datum = datum;
        }
        else
        {
            System.out.println("Fehler: kein gültiges Datum!");
            this.datum = LocalDate.now();
        }
    }
    
    public void setKurs(double kurs)
    {
        if (kurs > 0)
        {
            this.kurs = kurs;
        }
        else
        {
            System.out.println("Fehler: keine gültiger Kurs!");
            this.kurs = 1;
        }
    }
    
    public void printAktienKurs()
    {
        System.out.print(datum + " " + anzahl + " Stück " + kurs + " EUR\t");
        for (int j=1; j<=kurs; j++)
        {
            System.out.print("*");
        }
        System.out.println();
    }
}
