public class Auto
{
    private String kennzeichen;
    private int baujahr;
    private boolean automatik;
    private Parkplatz parkplatz;

    public Auto(String kennzeichen, int baujahr, boolean automatik)
    {
        setKennzeichen(kennzeichen);
        setAutomatik(automatik);
        setBaujahr(baujahr);
    }

    public Auto(String kennzeichen)
    {
        setKennzeichen(kennzeichen);
        setAutomatik(false);
        setBaujahr(2007);
    }

    public Auto(String kennzeichen, boolean automatik)
    {
        setKennzeichen(kennzeichen);
        setAutomatik(automatik);
        setBaujahr(2007);
    }

    public Auto()
    {
        setKennzeichen("BMW");
        setAutomatik(false);        
        setBaujahr(2007);
    }

    public String getKennzeichen()
    {
        return kennzeichen;
    }

    public int getBaujahr()
    {
        return baujahr;
    }

    public boolean getAutomatik()
    {
        return automatik;
    }
    
    public String getOrt()
    {
        //01234567
        //WN-123W
        //WN
        //2
        return kennzeichen.substring(0, kennzeichen.indexOf('-'));
    }
    
    public String getNummer()
    {
        return kennzeichen.substring(kennzeichen.indexOf('-')+1);
    }

    public Parkplatz getParkplatz()
    {
        return parkplatz;
    }
    
    public void setKennzeichen(String kennzeichen)
    {
        if ((kennzeichen != null) && (kennzeichen.length() >= 5) && (kennzeichen.contains("-") == true))
        {
            this.kennzeichen = kennzeichen.toUpperCase();
        }
        else
        {
            System.out.println("Fehler: kein Kennzeichen!");
            this.kennzeichen = "W-12345A";
        }
    }

    public void setBaujahr(int baujahr)
    {
        if (automatik == true)
        {
            //1985..2017
            if ((baujahr>=1985) && (baujahr<=2017))
            {
                this.baujahr = baujahr;
            }
            else
            {
                if (baujahr<1985)
                {
                    //zu klein
                    System.out.println("Fehler: Automatik Autos gibt erst ab dem Baujahr 1985!");
                    this.baujahr = 1985;
                }
                else
                {
                    //zu groß
                    System.out.println("Fehler: Automatik Autos gibt bis zum Baujahr 2017!");
                    this.baujahr = 2017;
                }
            }
        }
        else
        {
            //1960..2007
            if ((baujahr>=1960) && (baujahr<=2007))
            {
                this.baujahr = baujahr;
            }
            else
            {
                if (baujahr<1960)
                {
                    //zu klein
                    System.out.println("Fehler: Autos mit Schaltung gibt es ab dem Baujahr 1960!");
                    this.baujahr = 1960;
                }
                else
                {
                    //zu groß
                    System.out.println("Fehler: Autos mit Schaltung gibt bis zum Baujahr 2007!");
                    this.baujahr = 2007;
                }
            }
        }
    }

    public void setAutomatik(boolean automatik)
    {
        this.automatik = automatik;
    }
    
    public void setParkplatz(Parkplatz parkplatz)
    {
        this.parkplatz = parkplatz;
    }

    public void printAuto()
    {
        if (automatik == true)
        {
            System.out.println(kennzeichen + " - " + baujahr + " (AUTOMATIK)");
        }
        else
        {
            System.out.println(kennzeichen + " - " + baujahr + " (kein AUTOMATIK)");
        }
    }
    
    public void ausparken()
    {
        if (parkplatz != null)
        {
            parkplatz.ausparken(this);
        }
        else
        {
            System.out.println("Fehler: stehe auf keinem Parkplatz!");
        }
    }
}











