public class Parkplatz
{
    private Auto[] platze;
    
    public Parkplatz()
    {
        platze = new Auto[5];
    }
    
    public void einparken(Auto neu)
    {
        int i;
        boolean fertig;
        
        fertig = false;
        if (neu != null)
        {
            if (neu.getParkplatz() == null)
            {
                i = 0;
                while ((i < platze.length) && (fertig == false))
                {
                    if (platze[i] == null)
                    {
                        platze[i] = neu;
                        neu.setParkplatz(this);
                        fertig = true;
                    }
                    i++;
                }
                if (fertig == false)
                {
                    System.out.println("Fehler: kein Platz!");
                }
            }
            else
            {
                System.out.println("Fehler: Auto steht schon auf einem Parkplatz!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Auto!");
        }
    }

    public void printParkplatz()
    {
        for (int i=0; i<platze.length; i++)
        {
            if (platze[i] != null)
            {
                platze[i].printAuto();
            }
        }
    }

    public int anzahlAutomatik()
    {
        int anz;
        
        anz = 0;
        for (int i=0; i<platze.length; i++)
        {
            if (platze[i] != null)
            {
                if (platze[i].getAutomatik() == true)
                {
                    anz++;
                }
            }
        }
        return anz;
    }

    public double avgBaujahrAutomatik()
    {
        int sum;
        int anz;
        
        sum=0;
        anz=0;
        for (int i=0; i<platze.length; i++)
        {
            if (platze[i] != null)
            {
                if (platze[i].getAutomatik() == true)
                {
                    sum += platze[i].getBaujahr();
                    anz++;
                }
            }
        }
        if (anz > 0)
        {
            return (double)sum/anz;
        }
        else
        {
            System.out.println("Fehler: kein automatik Auto!");
            return 0;
        }
    }

    public int minBaujahr()
    {
        int min;
        
        min = 9999;
        for (int i=0; i<platze.length; i++)
        {
            if (platze[i] != null)
            {
                if (platze[i].getBaujahr() < min)
                {
                    min = platze[i].getBaujahr();
                }
            }
        }
        return min;
    }
    
    public void ausparken(Auto wer)
    {
        int i;
        boolean fertig;
        
        if (wer != null)
        {
            i=0;
            fertig = false;
            while ((i < platze.length) && (fertig == false))
            {
                if (platze[i] == wer)
                {
                    platze[i] = null;
                    wer.setParkplatz(null);
                    fertig = true;
                }
                i++;
            }
            if (fertig == false)
            {
                System.out.println("Fehler: Auto nicht am Parkplatz!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Auto!");
        }
    }
}











