public class Aktie
{
    private String name;
    private double[] kurs;
    private int anzahl;
    
    public Aktie(String name)
    {
        setName(name);
        kurs = new double[10];
        anzahl = 0;
    }
    
    public void testdaten1()
    {
        kurs[0] = 17.9;
        kurs[1] = 12.6;
        kurs[2] = 16.3;
        kurs[3] = 18.9;
        kurs[4] = 19.1;
        kurs[5] = 18.2;
        kurs[6] = 17.3;
        kurs[7] = 22.1;
        anzahl = 8;
    }
    
    public String getName()
    {
        return name;
    }
    
    public void setName(String name)
    {
        if (name != null)
        {
            this.name = name;
        }
        else
        {
            System.out.println("Fehler: kein Name");
            this.name = "UNKN";
        }
    }
    
    public void printAktie()
    {
        System.out.println(name);
        System.out.println();
        for (int i=0; i<anzahl; i++)
        {
            System.out.print(i + ". Tag: " + kurs[i] + "\t");
            for (int j=1; j<=kurs[i]; j++)
            {
                System.out.print("*");
            }
            System.out.println();
        }
    }
    
    public double maxKurs()
    {
        double max;
        
        max = -999;
        for (int i=0; i<anzahl; i++)
        {
            if (kurs[i] > max)
            {
                max = kurs[i];
            }
        }
        return max;
    }

    public int maxKursGew()
    {
        double max;
        int maxPos;
        
        max = -999;
        maxPos = -1;
        for (int i=1; i<anzahl; i++)
        {
            if ((kurs[i]-kurs[i-1]) > max)
            {
                max = kurs[i]-kurs[i-1];
                maxPos = i;
            }
        }
        return maxPos;
    }
    
    public void einfugen(int pos, double wert)
    {
        if ((pos >= 0) && (pos < anzahl))
        {
            if (wert > 0)
            {
                if (anzahl < kurs.length)
                {
                    for (int i=anzahl-1; i>=pos; i--)
                    {
                        kurs[i+1] = kurs[i];
                    }
                    kurs[pos] = wert;
                    anzahl++;
                }
                else
                {
                    System.out.println("Fehler: kann keine Werte mehr aufnehmen!");
                }
            }
            else
            {
                System.out.println("Fehler: ungültiger Kurs!");
            }
        }
        else
        {
            System.out.println("Fehler: ungültige Position!");
        }
    }
    
    public void umrechnen(double umrechnungskurs)
    {
        for (int i=0; i<anzahl; i++)
        {
            kurs[i] = kurs[i]*umrechnungskurs;
        }
    }
    
    public void bubbleSort()
    {
        double temp;
        boolean sorted;
        int j;
        
        sorted=false;
        j=0;
        while (sorted==false)
        {
            sorted=true;
            for (int i=0; i<anzahl-1-j; i++)
            {
                if (kurs[i]>kurs[i+1])
                {
                    temp=kurs[i];
                    kurs[i]=kurs[i+1];
                    kurs[i+1]=temp;
                    sorted=false;
                }
            }
            j++;
        }
    }
}

















