public class Hotel
{
    private String name;
    private int    maxZimmer;
    private int[]  belegt;
    
    public Hotel()
    {
        setName("Schlaf gut");
        setMaxZimmer(30);
        belegt = new int[15];
    }

    public void testdaten3()
    {
        belegt[0] = 25;
        belegt[1] = 12;
        belegt[2] = 19;
        belegt[3] = 22;
        belegt[4] = 28;
        belegt[5] = 30;
        belegt[6] = 7;
        belegt[7] = 29;
        belegt[8] = 30;
        belegt[9] = 27;
        belegt[10] = 9;
        belegt[11] = 12;
        belegt[12] = 9;
        belegt[13] = 5;
        belegt[14] = 12;
    }    
    
    public void testdaten2()
    {
        belegt[0] = 25;
        belegt[1] = 12;
        belegt[2] = 19;
        belegt[3] = 22;
        belegt[4] = 28;
        belegt[5] = 30;
        belegt[6] = 7;
        belegt[7] = 29;
        belegt[8] = 30;
        belegt[9] = 27;
        belegt[10] = 9;
        belegt[11] = 12;
        belegt[12] = 0;
        belegt[13] = 5;
        belegt[14] = 0;
    }
    
    public void testdaten()
    {
        belegt[0] = 25;
        belegt[1] = 12;
        belegt[2] = 19;
        belegt[3] = 22;
        belegt[4] = 5;
        belegt[5] = 9;
        belegt[6] = 7;
        belegt[7] = 30;
        belegt[8] = 30;
        belegt[9] = 30;
        belegt[10] = 9;
        belegt[11] = 12;
        belegt[12] = 0;
        belegt[13] = 5;
        belegt[14] = 0;
    }
    
    public String getName()
    {
        return name;
    }
    
    public int getMaxZimmer()
    {
        return maxZimmer;
    }
    
    public void setName(String name)
    {
        if (name != null)
        {
            this.name = name;
        }
        else
        {
            System.out.println("Fehler: ungültiger Name!");
            this.name = "Schlaf gut";
        }
    }
    
    public void setMaxZimmer(int maxZimmer)
    {
        if ((maxZimmer > 4) && (maxZimmer <= 200))
        {
            this.maxZimmer = maxZimmer;
        }
        else
        {
            System.out.println("Fehler: ungültige Zimmeranzahl!");
            this.maxZimmer = 100;
        }
    }
    
    public int tagHotelAllesFrei()
    {
        for (int i=0; i<belegt.length; i++)
        {
            if (belegt[i] == 0)
            {
                return i;
            }
        }
        return -1;
    }
    
    public int tagVollbelegt()
    {
        for (int i=0; i<belegt.length; i++)
        {
            if (belegt[i] == maxZimmer)
            {
                return i;
            }
        }
        return -1;
    }
    
    public int maximalBelegt()
    {
        int max;
        int maxTag;
        
        max = -999;
        maxTag = -999;
        for (int i=0; i<belegt.length; i++)
        {
            if (belegt[i] > max)
            {
                max = belegt[i];
                maxTag = i;
            }
        }
        return maxTag;
    }
    
    public int tageUber80Prozent()
    {
        int anz;
        
        anz=0;
        for(int i=0; i<belegt.length; i++)
        {
            //if (belegt[i] > ((maxZimmer*80)/100))
            if (belegt[i] > (((double)maxZimmer/100)*80))
            {
                anz++;
            }
        }
        return anz;
    }
    
    public int tageUnter50Prozent()
    {
        int anz;
        
        anz = 0;
        for (int i=0; i<belegt.length; i++)
        {
            if (belegt[i] < (maxZimmer/2))
            {
                anz++;
            }
        }
        return anz;
    }
    
    public void printHotel()
    {
        System.out.println(name + " maximale Zimmeranzahl: " + maxZimmer);
        for (int i=0; i<belegt.length; i++)
        {
            System.out.println("Tag " + i + ": " + belegt[i] + " Zimmer belegt / " + " " + (maxZimmer-belegt[i]) + " Zimmer frei");
        }
    }
    
    public void printHotelVerk()
    {
        System.out.println(name + " maximale Zimmeranzahl: " + maxZimmer);
        for (int i=belegt.length-1; i>=0; i--)
        {
            System.out.println("Tag " + i + ": " + belegt[i] + " Zimmer belegt / " + " " + (maxZimmer-belegt[i]) + " Zimmer frei");            
        }
    }
}




















