public class Parkplatz
{
    private Auto platz0;
    private Auto platz1;
    private Auto platz2;

    public void einparken(Auto neu)
    {
        if (neu != null)
        {
            if (neu.getParkplatz() == null)
            {
                if (platz0 == null)
                {
                    platz0 = neu;
                    neu.setParkplatz(this);
                }
                else
                {
                    if (platz1 == null)
                    {
                        platz1 = neu;
                        neu.setParkplatz(this);
                    }
                    else
                    {
                        if (platz2 == null)
                        {
                            platz2 = neu;
                            neu.setParkplatz(this);
                        }
                        else
                        {
                            System.out.println("Fehler: kein Platz mehr frei!");
                        }
                    }
                }
            }
            else
            {
                System.out.println("Fehler: Auto steht schon auf einem Parkplatz!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Auto!");
        }
    }

    public void printParkplatz()
    {
        if (platz0 != null)
        {
            platz0.printAuto();
        }
        if (platz1 != null)
        {
            platz1.printAuto();
        }
        if (platz2 != null)
        {
            platz2.printAuto();
        }
    }

    public int anzahlAutomatik()
    {
        int anz;

        anz = 0;
        if (platz0 != null)
        {
            if (platz0.getAutomatik() == true)
            {
                anz++;
            }
        }
        if (platz1 != null)
        {
            if (platz1.getAutomatik() == true)
            {
                anz++;
            }
        }
        if (platz2 != null)
        {
            if (platz2.getAutomatik() == true)
            {
                anz++;
            }
        }

        return anz;
    }

    public double avgBaujahrAutomatik()
    {
        int sum;
        int anz;

        sum = 0;
        anz = 0;
        if (platz0 != null)
        {
            if (platz0.getAutomatik() == true)
            {
                sum = sum + platz0.getBaujahr();
                anz++;
            }
        }
        if (platz1 != null)
        {
            if (platz1.getAutomatik() == true)
            {
                sum = sum + platz1.getBaujahr();
                anz++;
            }
        }
        if (platz2 != null)
        {
            if (platz2.getAutomatik() == true)
            {
                sum = sum + platz2.getBaujahr();
                anz++;
            }
        }

        if (anz > 0)
        {
            return (double)sum/anz;
        }
        else
        {
            System.out.println("Fehler: keine Autos!");
            return -999;
        }
    }

    public int minBaujahr()
    {
        int min;

        min = 99999;
        if (platz0 != null)
        {
            if (platz0.getBaujahr() < min)
            {
                min = platz0.getBaujahr();
            }
        }
        if (platz1 != null)
        {
            if (platz1.getBaujahr() < min)
            {
                min = platz1.getBaujahr();
            }
        }
        if (platz2 != null)
        {
            if (platz2.getBaujahr() < min)
            {
                min = platz2.getBaujahr();
            }
        }

        return min;
    }
    
    public void ausparken(Auto wer)
    {
        if (wer != null)
        {
            if (platz0 == wer)
            {
                platz0 = null;
                wer.setParkplatz(null);
            }
            else
            {
                if (platz1 == wer)
                {
                    platz1 = null;
                    wer.setParkplatz(null);
                }
                else
                {
                    if (platz2 == wer)
                    {
                        platz2 = null;
                        wer.setParkplatz(null);
                    }
                    else
                    {
                        System.out.println("Fehler: Auto steht nicht auf diesem Parlplatz!");
                    }
                }
            }
        }
        else
        {
            System.out.println("Fehler: kein Auto!");
        }
    }
}











