package application;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class RootBorderPane extends BorderPane
{
	private FlowPane flowPaneTop;
	private Label    label1;
	private RadioButton radioButton1, radioButton2, radioButton3;
	
	private GridPane gridPaneCenter;
	private Label    label2, label3, label4, label5;
	private Button   button2, button3, button4, button5;
	
	private FlowPane flowPaneBottom;
	private Button   buttonOK, buttonAbbruch; 	
	
	public RootBorderPane()
	{
		initComponents();
		addComponents();
	}

	private void initComponents()
	{
		flowPaneTop = new FlowPane();
		flowPaneTop.setAlignment(Pos.CENTER);
		flowPaneTop.setVgap(20);
		flowPaneTop.setHgap(20);
		label1 = new Label("Das sind RadioButtons in einer ToggleGroup");
		radioButton1 = new RadioButton();
		radioButton2 = new RadioButton();
		radioButton2.setSelected(true);
		radioButton3 = new RadioButton();
		
		gridPaneCenter = new GridPane();
		gridPaneCenter.setAlignment(Pos.CENTER);
		gridPaneCenter.setHgap(20);
		gridPaneCenter.setVgap(20);
		label2 = new Label("Das ist ein Button:");
		button2 = new Button("Button1");
		label3 = new Label("...ein weiterer Button...");
		button3 = new Button("Button2");
		label4 = new Label("...und noch ein Button...");
		button4 = new Button("Button3");
		label5 = new Label("...und da der letzte...");
		button5 = new Button("Button4");
		
		flowPaneBottom = new FlowPane();
		flowPaneBottom.setHgap(20);
		flowPaneBottom.setVgap(20);
		flowPaneBottom.setAlignment(Pos.BOTTOM_RIGHT);
		buttonOK = new Button("    OK    ");
		buttonAbbruch = new Button("Abbruch"); 	
	}

	private void addComponents()
	{
		new ToggleGroup().getToggles().addAll(radioButton1, radioButton2, radioButton3);
		flowPaneTop.getChildren().addAll(label1, radioButton1, radioButton2, radioButton3);
		
		gridPaneCenter.add(label2,  0, 0);
		gridPaneCenter.add(button2, 1, 0);
		gridPaneCenter.add(label3,  0, 1);
		gridPaneCenter.add(button3, 1, 1);
		gridPaneCenter.add(label4,  0, 2);
		gridPaneCenter.add(button4, 1, 2);
		gridPaneCenter.add(label5,  0, 3);
		gridPaneCenter.add(button5, 1, 3);
		
		flowPaneBottom.getChildren().addAll(buttonOK, buttonAbbruch);
		
		setTop(flowPaneTop);
		setCenter(gridPaneCenter);
		setBottom(flowPaneBottom);
	}
	
	
}

















