package application;

import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class RootBorderPane extends BorderPane
{
	private GridPane centerGridPane;
	private FlowPane topFlowPane, bottomFlowPane;
	private RadioButton rb1, rb2, rb3;
	
	public RootBorderPane()
	{	
		initComponents();
		addComponents();
	}
	private void initComponents()
	{
		centerGridPane = new GridPane();
//		setAlignment(centerGridPane, Pos.CENTER);
		centerGridPane.setHgap(20);
		centerGridPane.setVgap(20);
		centerGridPane.setAlignment(Pos.CENTER);
		
		topFlowPane = new FlowPane();
		topFlowPane.setAlignment(Pos.TOP_CENTER);
		topFlowPane.setHgap(10);
		
		bottomFlowPane = new FlowPane();
		bottomFlowPane.setAlignment(Pos.BOTTOM_RIGHT);
		bottomFlowPane.setHgap(5);

		rb1 = new RadioButton();
//			rb1.setSelected(true);
		rb2 = new RadioButton();
			rb2.setSelected(true);
		rb3 = new RadioButton();
//			rb3.setSelected(true);

	}
	private void addComponents()
	{
//		ToggleGroup toggleGroup = new ToggleGroup();
//		toggleGroup.getToggles().addAll(rb1, rb2, rb3);
		new ToggleGroup().getToggles().addAll(rb1, rb2, rb3);
//		rb1.setToggleGroup(toggleGroup);
//		rb2.setToggleGroup(toggleGroup);
//		rb3.setToggleGroup(toggleGroup);
		topFlowPane.getChildren().addAll(new Label("Das sind RadioButtons in einer ToggleGroup:  "), rb1, rb2, rb3 );		

		centerGridPane.add(new Label("Das ist ein Button: "), 0, 0);
		centerGridPane.add(new Button("Button1"), 1, 0);
		centerGridPane.add(new Label("...ein weiterer Button..."), 0, 1);
		centerGridPane.add(new Button("Button2"), 1, 1);
		centerGridPane.add(new Label("...und noch ein Button..."), 0, 2);
		centerGridPane.add(new Button("Button3"), 1, 2);
		centerGridPane.add(new Label("...und da der letzte:"), 0, 3);
		centerGridPane.add(new Button("Button4"), 1, 3);

		bottomFlowPane.getChildren().addAll(new Button("   OK   "), new Button("Abbruch"));

		setTop(topFlowPane);
		setCenter(centerGridPane);
		setBottom(bottomFlowPane);
	}
}
