package model;

import java.io.Serializable;
import java.util.Comparator;

@SuppressWarnings("serial")
public abstract class Mitarbeiter implements Comparable<Mitarbeiter>, Serializable
{
	private static int     lastId;
	private int            mitarbeiterId;
	private String         name;
	private int            geburtsJahr;
	private int            seitJahr;
	private boolean        spezialisiert;
	
	public Mitarbeiter(String zeile) throws FirmaException
	{
		//dflakdshfalkdsfhakf;Gudrun;1977;2017;sadlfhdsalfkhalskdfhalksdflkfdsahlkh
		String erg[];

		if (zeile != null)
		{
			try
			{
				setMitarbeiterId();
				erg = zeile.split(";");
				setName(erg[1]);
				int geb;
				geb = Integer.parseInt(erg[2]);
				setGeburtsJahr(geb);
				setSeitJahr(Integer.parseInt(erg[3]));
			}
			catch (NumberFormatException e)
			{
				throw new FirmaException("Fehler: keine Zahl! " + zeile);			
			}
			catch (ArrayIndexOutOfBoundsException e)
			{
				throw new FirmaException("Fehler: zu wenig Attribute definiert!" + zeile);
			}
		}
		else
		{
			throw new FirmaException("Fehler: eine Daten!");
		}
	}

	
	public Mitarbeiter(String name, int geburtsJahr, int seitJahr) throws FirmaException
	{
		setMitarbeiterId();
		setName(name);
		setGeburtsJahr(geburtsJahr);
		setSeitJahr(seitJahr);
	}

	public Mitarbeiter(String name, int geburtsJahr) throws FirmaException
	{
		setMitarbeiterId();
		setName(name);
		setGeburtsJahr(geburtsJahr);
		setSeitJahr(2021);
	}

	public void setMitarbeiterId()
	{
		lastId++;
		this.mitarbeiterId = lastId;
	}
	
	public int getMitarbeiterId()
	{
		return mitarbeiterId;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setName(String name) throws FirmaException
	{
		if (name != null)
		{
			this.name = name;
		}
		else
		{
			throw new FirmaException("Fehler: kein Name angegeben!");
		}
	}
	
	public int getGeburtsJahr()
	{
		return geburtsJahr;
	}
	
	public void setGeburtsJahr(int geburtsJahr)
	{
		this.geburtsJahr = geburtsJahr;
	}
	
	public int getSeitJahr()
	{
		return seitJahr;
	}
	
	public void setSeitJahr(int seitJahr) throws FirmaException
	{
		if (seitJahr >= (geburtsJahr+15))
		{
			this.seitJahr = seitJahr;
		}
		else
		{
			throw new FirmaException("Fehler: zu jung!");
		}
	}
	
	public String getInitialen() throws FirmaException
	{
		//01234567890123456789
		//Thomas Griesmayer
		//TG
		String erg;
		
		try
		{
			if (name.contains(" "))
			{
				erg = "";
				erg += name.charAt(0);
				erg += name.charAt(name.indexOf(' ')+1);
				return erg;
			}
			else
			{
				throw new FirmaException("Fehler: kein Vor- und Nachname!");
			}
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FirmaException("Fehler: Name ist leer!");
		}
	}
	
	public abstract double auszahlen();
	
	public abstract void erhohung(int prozent);
	
	public String toString()
	{
		return mitarbeiterId + " EUR " + auszahlen() + " " + name + " Geburtsjahr " + geburtsJahr + " Seit " + seitJahr;
	}
	
	public String toStringCSV()
	{
		return this.getClass().getSimpleName() + ";" + name + ";" + geburtsJahr + ";" + seitJahr;
	}
	
	@Override
	public int compareTo(Mitarbeiter other)
	{
		return (int)this.auszahlen() - (int)other.auszahlen();
	}
	
	public static class GeburtsJahrComparator implements Comparator<Mitarbeiter>
	{
		@Override
		public int compare(Mitarbeiter o1, Mitarbeiter o2)
		{
			return o1.getGeburtsJahr() - o2.getGeburtsJahr();
		}

	}
	
	public static class NameComparator implements Comparator<Mitarbeiter>
	{
		@Override
		public int compare(Mitarbeiter o1, Mitarbeiter o2)
		{
			// o1 <=> o2
			// o1.name <=> o2.name
			return o1.getName().compareTo(o2.getName());
		}
	}
	
	//sortierung seit name
	//2000 Max
	//2001 Alex
	//2001 Karl
	//2001 Maria
}














