package model;

public class Freelancer extends Mitarbeiter
{
	private boolean fertig;
	private double  betrag;
	
	public Freelancer(String zeile) throws FirmaException
	{
		super(zeile);
		//Freelancer;Gudrun;1977;2017;Fertig;150000
		String erg[];
		
		try
		{
			erg = zeile.split(";");
			if (erg[4].equals("Fertig"))
				setFertig(true);
			else
				setFertig(false);
			setBetrag(Double.parseDouble(erg[5]));
		}
		catch (NumberFormatException e)
		{
			throw new FirmaException("Fehler: keine Zahl! " + zeile);			
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			throw new FirmaException("Fehler: zu wenig Attribute definiert!" + zeile);
		}
	}
	
	public Freelancer(String name, int geburtsJahr, int seitJahr, boolean fertig, double betrag) throws FirmaException
	{
		super(name, geburtsJahr, seitJahr);
		setFertig(fertig);
		setBetrag(betrag);
	}

	public boolean isFertig()
	{
		return fertig;
	}
	
	public void setFertig(boolean fertig)
	{
		this.fertig = fertig;
	}
	
	public double getBetrag()
	{
		return betrag;
	}
	
	public void setBetrag(double betrag)
	{
		this.betrag = betrag;
	}
	
	@Override
	public String toString()
	{
		if (fertig)
			return "Freelancer " + super.toString() + " Fertig " + betrag + " EUR";
		else
			return "Freelancer " + super.toString() + " Offen " + betrag + " EUR";
	}

	@Override
	public double auszahlen()
	{
		if (fertig == true)
			return betrag;
		else
			return 0;
	}

	@Override
	public void erhohung(int prozent)
	{
	}
}
