package model;

public class Angestellter extends Mitarbeiter
{
	private static double    minGehalt = 2200;
	private double           gehalt;

	public Angestellter(String zeile) throws FirmaException
	{
		super(zeile);
		//Angestellter;Fritz;1970;2009;3700.0
		String erg[];
		
		try
		{
			erg = zeile.split(";");
			setGehalt(Double.parseDouble(erg[4]));
		}
		catch (NumberFormatException e)
		{
			throw new FirmaException("Fehler: keine Zahl! " + zeile);			
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			throw new FirmaException("Fehler: zu wenig Attribute definiert!" + zeile);
		}
	}
	
	public Angestellter(String name, int geburtsJahr, int seitJahr, double gehalt) throws FirmaException
	{
		super(name, geburtsJahr, seitJahr);
		setGehalt (gehalt);
	}
	
	public static double getMinGehalt()
	{
		return minGehalt;
	}

	public double getGehalt()
	{
		return gehalt;
	}

	public void setGehalt(double gehalt) throws FirmaException
	{
		if (gehalt >= minGehalt)
		{
			this.gehalt = gehalt;
		}
		else
		{
			throw new FirmaException("Fehler: mind. " + minGehalt + " Euro lt. Koll.vertrag!");
		}
	}

	@Override
	public String toString()
	{
		return "Angestellter " + super.toString() + " Gehalt: " + gehalt;
	}
	
	@Override
	public String toStringCSV()
	{
		return super.toStringCSV() + ";" + gehalt;
	}

	@Override
	public double auszahlen()
	{
		return gehalt*14 / 12;
	}

	@Override
	public void erhohung(int prozent)
	{
		gehalt += gehalt*prozent / 100;
	}
	
	
}
