package application;


import java.io.File;

import javafx.application.Platform;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.FileChooser.ExtensionFilter;
import model.Firma;
import model.FirmaException;

public class RootBorderPane extends BorderPane
{
	private Firma firma;
	
	private MenuBar menuBar;
	private Menu menuFile;
	private MenuItem menuItemImport, menuItemExport, menuItemLoad, menuItemSave, menuItemExit; 
	private Menu menuMitarbeiter;
	private MenuItem menuItemHire, menuItemFire;
	private Menu menuHelp;
	private MenuItem menuItemAbout;
	
	public RootBorderPane()
	{
		firma = new Firma("Super GmbH");
		
		initMenu();
		addMenu();
		
		initComponents();
		addComponents();
		addHandlers();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		menuFile = new Menu("File");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemExit = new MenuItem("Exit");
		menuHelp = new Menu("Help");
		menuItemAbout = new MenuItem("About");
	}

	private void addMenu()
	{
		menuFile.getItems().addAll(menuItemImport, menuItemExport, menuItemExit);
		menuHelp.getItems().addAll(menuItemAbout);
		menuBar.getMenus().addAll(menuFile, menuHelp);
	}

	private void initComponents()
	{
	}

	private void addComponents()
	{
		setTop(menuBar);
	}

	private void addHandlers()
	{
		menuItemExit.setOnAction( event -> beenden() );
		menuItemAbout.setOnAction( event -> about());
		menuItemImport.setOnAction( event -> importFirma() );
	}

	private void importFirma()
	{
		try
		{
			FileChooser fileChooser;
			File selected;
			
			fileChooser = new FileChooser();
			fileChooser.setTitle("Import Firma");
			fileChooser.getExtensionFilters().addAll(
			         new ExtensionFilter("Text Files", "*.txt", "*.csv"));
			selected = fileChooser.showOpenDialog(null);
			if (selected != null)
			{
				firma.importFirma(selected.getAbsolutePath());
				System.out.println(firma);
			}
		}
		catch (FirmaException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}

	private void about()
	{
		Main.showAlert(AlertType.INFORMATION, "Firma Super GmbH 2021\n4AKIF");
	}

	private void beenden()
	{
		Platform.exit();
	}
}
