package model;

public class Manager extends Mitarbeiter
{
	private double gehalt;
	private double jahresBonus;

	public Manager(String name, int geburtsJahr, int seitJahr, double gehalt, double jahresBonus) throws FirmaException
	{
		super(name, geburtsJahr, seitJahr);
		setGehalt(gehalt);
		setJahresBonus (jahresBonus);
	}
	
	public double getGehalt()
	{
		return gehalt;
	}
	
	public void setGehalt(double gehalt)
	{
		this.gehalt = gehalt;
	}

	public double getJahresBonus()
	{
		return jahresBonus;
	}

	public void setJahresBonus(double jahresBonus)
	{
		this.jahresBonus = jahresBonus;
	}
	
	@Override
	public double auszahlen()
	{
		return (gehalt + (jahresBonus/12));
	}

	@Override
	public String toString()
	{
		return "Manager " + super.toString() + "Gehalt: " + gehalt + " Jahresbonus: " + jahresBonus;
	}

	@Override
	public void erhohung(int prozent)
	{
		gehalt += gehalt*((double)prozent/2) / 100;
	}
	
	
}
