package model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;

public class Firma
{
	private String name;
	private ArrayList<Mitarbeiter> mitarbeiter;
	
	public Firma(String name)
	{
		setName(name);
		mitarbeiter = new ArrayList<>();
	}

	public String getName()
	{
		return name;
	}
	
	public void setName(String name)
	{
		this.name = name;
	}

	public String toString()
	{
		//return "Firma " + name + ", mitarbeiter=" + mitarbeiter;
		String erg;
		
		erg = "Firma" + name + "\n";
		for (Mitarbeiter m : mitarbeiter)
		{
			erg = erg + m.toString() + "\n";
		}
		return erg;
	}
	
	public String toStringCSV()
	{
		String erg = "";
		
		for (Mitarbeiter m : mitarbeiter)
		{
			erg = erg + m.toStringCSV() + "\n";
		}
		return erg;
	}
	
	public int anzAngestellte()
	{
		return 0;
		//Anzahl der Angestellten mit mind. 2500 Euro pro Monat!
	}
	
	public int anzArbeiter()
	{
		int anz = 0;
		
		for (Mitarbeiter m: mitarbeiter)
		{
			//if (m.getClass().getSimpleName().equals("Arbeiter"))
			//if (m instanceof Object)
			//if (m instanceof Mitarbeiter)
			if (m instanceof Arbeiter)
			{
				Arbeiter a;
				a = (Arbeiter) m;
				if (a.getStunden() >= 20)
					anz++;
			}
		}
		return anz;
	}
	
	public void abmelden(double gehalt) throws FirmaException
	{
		boolean gefunden;
		Mitarbeiter m;
		Iterator<Mitarbeiter> it;

		gefunden = false;
		if (gehalt > 0)
		{
			it = mitarbeiter.iterator();
			while (it.hasNext())
			{
				m = it.next();
				if (m.auszahlen() >= gehalt)
				{
					it.remove();
					gefunden = true;
				}
			}
		}
		else
			throw new FirmaException("Fehler: Der Gehalt muss eine positive Zahl sein!");
		if ( ! gefunden)
			throw new FirmaException("Fehler: Keinen Mitarbeiter gefunden!");
	}

	public void aufnehmen(Mitarbeiter neuMitarbeiter)
	{
		if (neuMitarbeiter != null)
		{
			if ( ! (mitarbeiter.contains(neuMitarbeiter)) )
			{
				mitarbeiter.add(neuMitarbeiter);
			}
			else
			{
				System.out.println("Fehler: schon bei uns!");
			}
		}
		else
		{
			System.out.println("Fehler: kein Mitarbeiter!");	
		}
	}
	
	public void erhohung(int prozent) throws FirmaException
	{
		if (prozent > 0)
		{
			for (Mitarbeiter m : mitarbeiter)
			{
				m.erhohung(prozent);
			}
		}
		else
			throw new FirmaException("Fehler: Prozentsatz muss positiv sein!");
	}
	
	public void exportFirma(String filename) throws FirmaException
	{
		if (filename != null)
		{
			try
			{
				FileWriter fw = new FileWriter(filename);
				BufferedWriter bw = new BufferedWriter(fw);
				
				bw.write(toStringCSV());
				
				bw.close();
				fw.close();
			}
			catch (FileNotFoundException e)
			{
				throw new FirmaException("Fehler: Ungültiger Pfad!");
			}
			catch (IOException e)
			{
				throw new FirmaException("Fehler: Datei konnte nicht geschrieben werden!");
			}
		}
		else
			throw new FirmaException("Fehler: kein Dateiname!");
	}
	
	public void importFirma(String filename) throws FirmaException
	{
		if (filename != null)
		{
			try
			{
				String zeile;
				FileReader fr;
				fr = new FileReader(filename);
				BufferedReader br = new BufferedReader(fr);
				zeile = br.readLine();
				while (zeile != null)
				{
					if (zeile.startsWith("Angestellter"))
						aufnehmen(new Angestellter(zeile));
					else if (zeile.startsWith("Arbeiter"))
					{
						Arbeiter arbeiter;
						arbeiter = new Arbeiter(zeile);
						aufnehmen(arbeiter);
					}
					
					zeile = br.readLine();
				}
				br.close();
				fr.close();
			}
			catch (FileNotFoundException e)
			{
				throw new FirmaException("Fehler: Datei nicht gefunden!");
			}
			catch (IOException e)
			{
				throw new FirmaException("Fehler: Datei konnte nicht gelesen werden!");
			}
		}
		else
		{
			throw new FirmaException("Fehler: kein Dateinname!");
		}
	}
	
	public void saveFirma(String filename) throws FirmaException
	{
		if (filename != null)
		{
			try
			{
				FileOutputStream fos = new FileOutputStream(filename);
				ObjectOutputStream oos = new ObjectOutputStream(fos);
				oos.writeObject(mitarbeiter);
				oos.close();
				fos.close();
			}
			catch (FileNotFoundException e)
			{
				throw new FirmaException("Fehler: Ungültiger Pfad!");
			}
			catch (IOException e)
			{
				throw new FirmaException("Fehler: Datei konnte nicht geschrieben werden!");
			}	
		}
		else
		{
			throw new FirmaException("Fehler: kein Dateiname!");
		}
	}
	
	@SuppressWarnings("unchecked")
	public void loadFirma(String filename) throws FirmaException
	{
		if (filename != null)
		{
			try
			{
				ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));
				mitarbeiter = (ArrayList<Mitarbeiter>) ois.readObject();
				ois.close();
			}
			catch (ClassNotFoundException e)
			{
				throw new FirmaException("Fehler: Datei hat ein ungültiges Format!");
			}
			catch (FileNotFoundException e)
			{
				throw new FirmaException("Fehler: Ungültiger Pfad!");
			}
			catch (IOException e)
			{
				throw new FirmaException("Fehler: Datei konnte nicht gelesen werden!");
			}
		}
		else
		{
			throw new FirmaException("Fehler: kein Dateiname!");
		}
	}
	
	public void sort()
	{
		Collections.sort(mitarbeiter);
	}
	
	public void sortName()
	{
		Collections.sort(mitarbeiter, new Mitarbeiter.NameComparator());
	}

	public void sortJahrName()
	{
		Collections.sort(mitarbeiter, new JahrNameComparator());
	}

	public void sortAuszahlen()
	{
		Collections.sort(mitarbeiter, new AuszahlenComperator());
	}

	public void sortGeburtsJahr()
	{
		Collections.sort(mitarbeiter, new Mitarbeiter.GeburtsJahrComparator());
	}
}



















