package model;

public class Arbeiter extends Mitarbeiter
{
	private int stunden;
	private double stundenLohn;
	
	public Arbeiter(String zeile) throws FirmaException
	{
		//Arbeiter;Max;1961;2008;30;35
		super(zeile);
		
		String []erg;
		try
		{
			erg = zeile.split(";");
			setStunden(Integer.parseInt(erg[4]));
			setStundenLohn(Double.parseDouble(erg[5]));
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			throw new FirmaException("Fehler: Zeile hat keine Stunden bzw. Stundenlohn! " + zeile);
		}
		catch (NumberFormatException e)
		{
			throw new FirmaException("Fehler: keine Zahl für Stunden bzw. Stundenlohn! " + zeile);			
		}
	}
	
	public Arbeiter(String name, int geburtsJahr, int seitJahr, int stunden, double stundenLohn) throws FirmaException
	{
		super(name, geburtsJahr, seitJahr);
		setStunden (stunden);
		setStundenLohn (stundenLohn);
	}

	public int getStunden()
	{
		return stunden;
	}
	
	public void setStunden(int stunden)
	{
		this.stunden = stunden;
	}
	
	public double getStundenLohn()
	{
		return stundenLohn;
	}
	
	public void setStundenLohn(double stundenLohn) throws FirmaException
	{
		if (stundenLohn >= 20)
			this.stundenLohn = stundenLohn;
		else
			throw new FirmaException("Fehler: mind 20 Euro pro Stunde!");
	}

	@Override
	public String toString()
	{
		return "Arbeiter " + super.toString() + " Stunden: " + stunden + " Stundenlohn: " + stundenLohn;
	}
	
	@Override
	public String toStringCSV()
	{
		return super.toStringCSV() + ";" + stunden + ";" + stundenLohn;
	}

	@Override
	public double auszahlen()
	{
		return stunden*stundenLohn;
	}

	@Override
	public void erhohung(int prozent)
	{
		stundenLohn = stundenLohn * (100+prozent) / 100;
	}
	
	
}
