package application;


import javafx.application.Platform;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	private Menu menuFile;
	private MenuItem menuItemImport, menuItemExport, menuItemLoad, menuItemSave, menuItemExit; 
	private Menu menuMitarbeiter;
	private MenuItem menuItemHire, menuItemFire;
	private Menu menuHelp;
	private MenuItem menuItemAbout;
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		
		initComponents();
		addComponents();
		addHandlers();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		menuFile = new Menu("File");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemExit = new MenuItem("Exit");
		menuHelp = new Menu("Help");
		menuItemAbout = new MenuItem("About");
	}

	private void addMenu()
	{
		menuFile.getItems().addAll(menuItemImport, menuItemExport, menuItemExit);
		menuHelp.getItems().addAll(menuItemAbout);
		menuBar.getMenus().addAll(menuFile, menuHelp);
	}

	private void initComponents()
	{
	}

	private void addComponents()
	{
		setTop(menuBar);
	}

	private void addHandlers()
	{
		menuItemExit.setOnAction( event -> beenden() );
	}

	private void beenden()
	{
		Platform.exit();
	}
}
