package application;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class RootGridPane extends GridPane
{
	private Button b1, b2, b3,
	               b4, b5, b6, b7, b8;
	private FlowPane fpRechtsUnten;
	
	public RootGridPane()
	{
		initComponents();
		addComponents();
		addHandlers();
	}
	
	private void initComponents()
	{
		b1 = new Button("button1");
			b1.setPrefSize(100, 100);
			b1.setAlignment(Pos.BOTTOM_RIGHT);
			setHalignment(b1, HPos.CENTER);
			setValignment(b1, VPos.BOTTOM);
		b2 = new Button("Laden-Button");
			b2.setPrefSize(200, 200);
			b2.setAlignment(Pos.TOP_CENTER);
		b3 = new Button("Speichern-Button");
			b3.setPrefSize(200, 200);
			b3.setAlignment(Pos.BOTTOM_LEFT);
		fpRechtsUnten = new FlowPane();
			fpRechtsUnten.setPrefSize(200, 200);
			fpRechtsUnten.setAlignment(Pos.CENTER_LEFT);
			fpRechtsUnten.setVgap(10);
			fpRechtsUnten.setHgap(15);
			fpRechtsUnten.setPadding(new Insets(10));
		b4 = new Button("button vier");
		b5 = new Button("button 5");
		b6 = new Button("button 6");
		b7 = new Button("button 7");
		b8 = new Button("button 8");
	}
	
	private void addComponents()
	{
		add(b1, 0, 0);
		add(b2, 1, 0);
		add(b3, 0, 1);
		
		fpRechtsUnten.getChildren().addAll(b4, b5, b6, b7, b8);
		add(fpRechtsUnten, 1, 1);
	}

	private void speichern()
	{
		System.out.println("Button 3 gedrückt");
		System.out.println("Daten wurden gespeichert!!!");
	}
	
	private void addHandlers()
	{
		b1.setOnAction( event -> System.out.println("Button 1 gedrückt!") );;
		b2.setOnAction( event -> System.out.println("button 2 pressed") );
		b3.setOnAction( event -> speichern() );
	
	}
}















