import java.io.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class Unternehmen
{
    private String name;
    private ArrayList<Zug> zuge;

    public Unternehmen(String name) throws ZugException
    {
        setName(name);
        zuge = new ArrayList<>();
    }

    public void hinzufugen(Zug z) throws ZugException
    {
        if (z==null)
            throw new ZugException("Fehler: kein Zug!");
        if (zuge.contains(z))
            throw new ZugException("Fehler: Zug schon vorhanden!");

        zuge.add(z);
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name) throws ZugException
    {
        if (name == null)
            throw new ZugException("Fehler: der Name fehlt!");

        this.name = name;
    }

    public void addKm(int km) throws ZugException
    {
        if (km <= 0)
            throw new ZugException("Fehler: Die hinzugefügten km müssen zumindest mind. 1 sein");

        for (Zug z : zuge)
        {
            z.setKm(z.getKm() + km);
        }
    }

    public Zug maxKm()
    {
        double maxKm;
        Zug maxZug;

        maxKm = -99999;
        maxZug = null;
        for (Zug z : zuge)
        {
            if (z.getKm() > maxKm)
            {
                maxKm = z.getKm();
                maxZug = z;
            }
        }
        return maxZug;
    }

    public double prozentGuterZuge() throws ZugException
    {
        int anzGuterZuge;

        if (zuge.size() == 0)
            throw new ZugException("Fehler: kein Zug vorhanden!");

        anzGuterZuge = 0;
        for (Zug z : zuge)
        {
            if (z instanceof GuterZug)
                anzGuterZuge++;
        }
        return ((double)anzGuterZuge)*100/zuge.size();
    }

    public int loscheOhneZulassung()
    {
        int anz;
        Zug z;
        Iterator<Zug> it;

        anz = 0;
        it = zuge.iterator();
        while (it.hasNext())
        {
            z = it.next();
            if (z.isZulassung() == false)
            {
                it.remove();
                anz++;
            }
        }
        return anz;
    }

    public void exportieren() throws ZugException
    {
        FileWriter fw;
        BufferedWriter bw;

        try
        {
            fw = new FileWriter("data2.txt");
            bw = new BufferedWriter(fw);
            for (Zug z: zuge)
            {
                bw.write(z.toStringFile());
                bw.newLine();
            }
            bw.close();
            fw.close();
        }
        catch (IOException e)
        {
            throw new ZugException("Fehler: kann Daten nicht exportieren!");
        }
    }

    public void importieren() throws ZugException
    {
        String zeile;
        FileReader fr;
        BufferedReader br;

        try
        {
            fr = new FileReader("data.txt");
            br = new BufferedReader(fr);
            zeile = br.readLine();
            while (zeile != null)
            {
                //System.out.println(zeile);
                if (zeile.startsWith("G"))
                {
                    hinzufugen(new GuterZug(zeile));
                }
                else
                {
                    hinzufugen(new PersonenZug(zeile));
                }
                zeile = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e)
        {
            throw new ZugException("Fehler: Datei nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new ZugException("Fehler: kann auf die Daten nicht zugreifen!");
        }

    }

    public void laden() throws ZugException
    {
        ObjectInputStream ois;
        FileInputStream fis;

        try
        {

            fis = new FileInputStream("data.ser");
            ois = new ObjectInputStream(fis);
            zuge = (ArrayList<Zug>) ois.readObject();
            ois.close();
            fis.close();
        }
        catch (FileNotFoundException e)
        {
            throw new ZugException("Fehler: Datei oder Pfad nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new ZugException("Fehler: Datei nicht lesbar!");
        }
        catch (ClassNotFoundException e)
        {
            throw new ZugException("Fehler: Datei enthält keine Zugdaten!");
        }

    }

    public void speichern() throws ZugException
    {
        ObjectOutputStream oos;
        FileOutputStream fos;

        try
        {
            fos = new FileOutputStream("data.ser");
            oos = new ObjectOutputStream(fos);
            oos.writeObject(zuge);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e)
        {
            throw new ZugException("Fehler: Datei oder Pfad nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new ZugException("Fehler: Daten können nicht geschrieben werden!");
        }

    }

    public boolean contains(Zug z)
    {
        return zuge.contains(z);
    }

    public void sortKm()
    {
        Collections.sort(zuge);
    }

    public void sortBahnhof()
    {
        Collections.sort(zuge, new Comparator<Zug>()
        {
            @Override
            public int compare(Zug z1, Zug z2)
            {
                return z1.getBahnhof().compareTo(z2.getBahnhof());
            }
        });
    }

    public void sortArt()
    {
        Collections.sort(zuge, new Comparator<Zug>()
        {
            @Override
            public int compare(Zug z1, Zug z2)
            {
                if (((z1 instanceof PersonenZug) && (z2 instanceof PersonenZug)) ||
                    ((z1 instanceof GuterZug) && (z2 instanceof GuterZug)))
                {
                    return (int) (z1.km - z2.km);
                }
                else
                {
                    if ((z1 instanceof PersonenZug) && (z2 instanceof GuterZug))
                    {
                        return -1;
                    }
                    else
                    {
                        return 1;
                    }
                }
            }
        });
    }

    public void sortWagon()
    {
        Collections.sort(zuge, new Comparator<Zug>()
        {
            @Override
            public int compare(Zug z1, Zug z2)
            {
                return z1.anzahlWagon - z2.anzahlWagon;
            }
        });
    }

    @Override
    public String toString()
    {
        String erg;

        erg = "Unternehmen: " + name + "\n";
        for (Zug z: zuge)
        {
            erg = erg + z.toString() + "\n";
        }
        return erg;
    }
}
