import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class UnternehmenTest
{
    @Test
    public void testZusammen()
    {
        Zug w,t;

        try
        {
            w = new GuterZug("G:Wien:2000:Y:5");
            t = new PersonenZug("P:Baden:10000:N:5:500");
            System.out.println(w.toStringFile());
            System.out.println(t.toStringFile());
        }
        catch (ZugException e)
        {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testImportieren()
    {
        Unternehmen u;

        try
        {
            u = new Unternehmen("Zug");
            u.importieren();
            System.out.println(u);
            u.exportieren();
        }
        catch (ZugException e)
        {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testZerlegen()
    {
        Zug w,t;

        try
        {
            w = new GuterZug("G:Wien:2000:Y:5");
            t = new PersonenZug("P:Baden:10000:N:5:500");
            System.out.println(w);
            System.out.println(t);
        }
        catch (ZugException e)
        {
            System.out.println(e.getMessage());
        }
    }


    @Test
    public void testSpeichernLaden()
    {
        Zug a, b, c, d, e, f, g;
        Unternehmen u;
        Unternehmen u2;

        try
        {
            u = new Unternehmen("SuperSchnell");
            u2 = new Unternehmen("Der Neue");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            u.hinzufugen(g);
            System.out.println(u);
            u.speichern();
            u2.laden();
            System.out.println("===================================================");
            System.out.println(u2);
            assertEquals(1, 1);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1, 0);
        }
    }

    @Test
    public void testLoscheOhneZulassung()
    {
        Zug a, b, c, d, e, f, g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            assertEquals(0, u.loscheOhneZulassung());
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            u.hinzufugen(g);
            assertEquals(2, u.loscheOhneZulassung());

            assertEquals(true, u.contains(a));
            assertEquals(false, u.contains(b));
            assertEquals(true, u.contains(c));
            assertEquals(false, u.contains(d));
            assertEquals(true, u.contains(e));
            assertEquals(true, u.contains(f));
            assertEquals(true, u.contains(g));

            System.out.println(u);

            assertEquals(1, 1);
        } catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1, 0);
        }
    }


    @Test
    public void testProzentGuter()
    {
        Zug a, b, c, d, e, f, g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            u.hinzufugen(g);

            assertEquals(42.85, u.prozentGuterZuge(), 0.01);
            assertEquals(1, 1);
        } catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1, 0);
        }
    }

    @Test
    public void testMaxKmNull()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            assertEquals(null, u.maxKm());
            System.out.println(u);
            assertEquals(1,1);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,0);
        }

    }

    @Test
    public void testMaxKm()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            assertEquals(e, u.maxKm());
            u.hinzufugen(g);
            assertEquals(g, u.maxKm());
            assertEquals(1,1);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,0);
        }

    }



    @Test
    public void testAddKmNegativ()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            u.addKm(-4);
            System.out.println(u);
            assertEquals(1,0);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,1);
        }

    }

    @Test
    public void testAddKm()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            u.hinzufugen(g);
            System.out.println(u);
            u.addKm(5);
            System.out.println(u);

            assertEquals(5, a.getKm(), 0.5);
            assertEquals(1005, b.getKm(), 0.5);
            assertEquals(1505, c.getKm(), 0.5);
            assertEquals(5, d.getKm(), 0.5);
            assertEquals(2005, e.getKm(), 0.5);
            assertEquals(1705, f.getKm(), 0.5);
            assertEquals(15005, g.getKm(), 0.5);

            assertEquals(1,1);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,0);
        }

    }

    @Test
    public void testHinzufugenNull()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            u.hinzufugen(null);
            System.out.println(u);
            assertEquals(1,0);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testHinzufugenDoppelt()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            u.hinzufugen(a);
            u.hinzufugen(a);
            System.out.println(u);
            assertEquals(1,0);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testHinzufugen()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            u.hinzufugen(g);
            System.out.println(u);
            assertEquals(1,1);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,0);
        }
    }
}